/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Permission;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class Notification {
    public String subject;
    public String textBody;
    public String htmlBody;
    public To to = new To();
    public Restrict restrict = new Restrict();

    public Notification subject(String subject) {
        this.subject = subject;
        return this;
    }

    public Notification textBody(String text) {
        this.textBody = text;
        return this;
    }

    public Notification htmlBody(String html) {
        this.htmlBody = html;
        return this;
    }

    public Notification toReporter() {
        this.to.reporter = true;
        return this;
    }

    public Notification toAssignee() {
        this.to.assignee = true;
        return this;
    }

    public Notification toWatchers() {
        this.to.watchers = true;
        return this;
    }

    public Notification toVoters() {
        this.to.voters = true;
        return this;
    }

    public Notification toEmail(String email) {
        this.to.emails.add(email);
        return this;
    }

    public Notification toUser(String user) {
        UserBean userBean = new UserBean();
        userBean.name = user;
        this.to.users.add(userBean);
        return this;
    }

    public Notification toGroup(String group) {
        this.to.groups.add(new Group().name(group));
        return this;
    }

    public Notification restrictToGroup(String group) {
        this.restrict.groups.add(new Group().name(group));
        return this;
    }

    public Notification restrictToPermission(int permissionId) {
        this.restrict.permissions.add(new Permission().id(permissionId));
        return this;
    }

    public Notification restrictToPermission(String permissionKey) {
        this.restrict.permissions.add(new Permission().key(permissionKey));
        return this;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static final class Restrict {
        public final List<Group> groups = Lists.newArrayList();
        public final List<Permission> permissions = Lists.newArrayList();

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static final class To {
        public boolean reporter;
        public boolean assignee;
        public boolean watchers;
        public boolean voters;
        public final List<String> emails = Lists.newArrayList();
        public final List<UserBean> users = Lists.newArrayList();
        public final List<Group> groups = Lists.newArrayList();

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

