/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.AdministrationImpl;
import com.atlassian.jira.functest.framework.backdoor.ProfilingControl;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.util.function.Predicates;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdLogEntry;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdMetricName;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.testcontainers.shaded.org.awaitility.Awaitility;

public abstract class BaseInProductDiagnosticsTest
extends EmailBaseFuncTestCase {
    private static final String IPD_LOG_FILE_PATH = "log/atlassian-jira-ipd-monitoring.log";
    protected static final String[] SHORT_LOG_STATS_ATTRIBUTES = new String[]{"_99thPercentile", "_max", "_min", "_mean", "_count"};
    protected static final String[] ALL_LOG_STATS_ATTRIBUTES = new String[]{"_50thPercentile", "_75thPercentile", "_95thPercentile", "_98thPercentile", "_999thPercentile", "_99thPercentile", "_count", "_durationUnit", "_fifteenMinuteRate", "_fiveMinuteRate", "_max", "_min", "_mean", "_meanRate", "_oneMinuteRate", "_rateUnit", "_stdDev"};
    protected static final String[] JMX_STATS_ATTRIBUTES = new String[]{"50thPercentile", "75thPercentile", "95thPercentile", "98thPercentile", "999thPercentile", "99thPercentile", "Count", "DurationUnit", "FifteenMinuteRate", "FiveMinuteRate", "Max", "Min", "Mean", "MeanRate", "OneMinuteRate", "RateUnit", "StdDev"};
    protected static final String JMX_VALUE_ATTRIBUTE = "Value";
    protected static final String LOG_VALUE_ATTRIBUTE = "_value";
    protected static final double UNEXPECTED_JMX_VALUE = -1.0;
    private static final FeatureFlag IN_PRODUCT_DIAGNOSTICS_FLAG = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.featureKey());
    private static final FeatureFlag IN_PRODUCT_DIAGNOSTICS_WIP_FLAG = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS_WIP.featureKey());
    private static final FeatureFlag IPD_EXTRA_LOGGING_FLAG = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IPD_EXTRA_LOGGING.featureKey());
    private static final int JSON_CONTENT_POSITION = 3;
    private static final String LOG_LINE_ELEMENTS_SEPARATOR = " ";
    private static final int DEFAULT_JMX_PORT = 8199;
    protected ProfilingControl profilingControl;
    protected Administration administration;

    @Before
    public void setUp() {
        this.profilingControl = new ProfilingControl(this.environmentData);
        this.administration = new AdministrationImpl(this.tester, this.environmentData, this.navigation, this.assertions);
    }

    @Override
    @Before
    public void createMailService() {
    }

    @Override
    @After
    public void stopMailService() {
    }

    public static Stream<String> getIrregularMetrics() {
        return IpdMetricName.IRREGULAR_IPD_METRIC_NAMES.stream().map(IpdMetricName::getStatisticsName).filter(Objects::nonNull);
    }

    public static Stream<String> getStatsMetrics() {
        return IpdMetricName.REGULAR_IPD_METRIC_NAMES.stream().map(IpdMetricName::getStatisticsName).filter(Objects::nonNull);
    }

    public static Stream<String> getLastValueMetrics() {
        return IpdMetricName.REGULAR_IPD_METRIC_NAMES.stream().map(IpdMetricName::getLastValueName).filter(Objects::nonNull);
    }

    public static Stream<String> getCounterMetrics() {
        return IpdMetricName.REGULAR_IPD_METRIC_NAMES.stream().map(IpdMetricName::getCounterName).filter(Objects::nonNull);
    }

    public static Stream<String> getCustomMetrics() {
        return IpdMetricName.REGULAR_IPD_METRIC_NAMES.stream().map(IpdMetricName::getCustomName).filter(Objects::nonNull);
    }

    protected Stream<String> getAllTypesMetricsWithoutOnDemand() {
        ArrayList<IpdMetricName> ipdMetricNamesWithoutOnDemand = new ArrayList<IpdMetricName>(IpdMetricName.REGULAR_IPD_METRIC_NAMES);
        ipdMetricNamesWithoutOnDemand.removeAll(IpdMetricName.ON_DEMAND_IPD_METRIC_NAMES);
        return ipdMetricNamesWithoutOnDemand.stream().flatMap(metricName -> Stream.of(metricName.getLastValueName(), metricName.getStatisticsName(), metricName.getCounterName())).filter(Objects::nonNull);
    }

    protected void enableIPDFeature() {
        this.backdoor.darkFeatures().enableForSite(IN_PRODUCT_DIAGNOSTICS_FLAG);
    }

    protected void disableIPDFeature() {
        this.backdoor.darkFeatures().disableForSite(IN_PRODUCT_DIAGNOSTICS_FLAG);
    }

    protected void enableIpdWipFeature() {
        this.backdoor.darkFeatures().enableForSite(IN_PRODUCT_DIAGNOSTICS_WIP_FLAG);
    }

    protected void disableIpdWipFeature() {
        this.backdoor.darkFeatures().disableForSite(IN_PRODUCT_DIAGNOSTICS_WIP_FLAG);
    }

    protected void enableIPDExtraLogging() {
        this.backdoor.darkFeatures().enableForSite(IPD_EXTRA_LOGGING_FLAG);
    }

    protected void disableIPDExtraLogging() {
        this.backdoor.darkFeatures().disableForSite(IPD_EXTRA_LOGGING_FLAG);
    }

    protected void assertIPDFeatureState(boolean flagState) {
        Assertions.assertThat((boolean)this.backdoor.darkFeatures().isGlobalEnabled(IN_PRODUCT_DIAGNOSTICS_FLAG)).isEqualTo(flagState);
    }

    protected List<IpdLogEntry> readDistinctRegularLogMetricsInIpdLogFile() throws IOException {
        File logfile = new File(this.administration.getJiraHomeDirectory(), IPD_LOG_FILE_PATH);
        return this.readMetricsInLogFileOnCondition(logfile, () -> logfile.length() > 0L && this.containsRegularLogEntry(logfile)).stream().filter(Predicates.distinctByKey(IpdLogEntry::getLabel)).collect(Collectors.toList());
    }

    protected List<IpdLogEntry> readMetricsInLogFileOnCondition(File logfile, BooleanSupplier supplier) throws IOException {
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).with().pollDelay(2L, TimeUnit.SECONDS).pollInterval(15L, TimeUnit.SECONDS).untilAsserted(() -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)supplier.getAsBoolean()).describedAs("IPD log file is empty or contains only on-demand metrics.", new Object[0])).isTrue());
        return Files.readAllLines(logfile.toPath()).stream().map(this::getLogJsonContent).map(this::parseIpdLogEntry).collect(Collectors.toList());
    }

    protected List<IpdLogEntry> readOnDemandMetricsInIpdLogFile(File logfile) throws IOException {
        return this.readMetricsInLogFileOnCondition(logfile, () -> logfile.length() > 0L);
    }

    protected List<IpdLogEntry> readOnDemandMetricsInIpdLogFile() throws IOException {
        File logfile = new File(this.administration.getJiraHomeDirectory(), IPD_LOG_FILE_PATH);
        return this.readMetricsInLogFileOnCondition(logfile, () -> logfile.length() > 0L);
    }

    private boolean containsRegularLogEntry(File logFile) {
        try {
            List ipdMetricNamesWithoutOnDemand = IpdMetricName.REGULAR_IPD_METRIC_NAMES.stream().filter(metricName -> !IpdMetricName.ON_DEMAND_IPD_METRIC_NAMES.contains(metricName)).flatMap(metricName -> Stream.of(metricName.getLastValueName(), metricName.getStatisticsName(), metricName.getCounterName())).filter(Objects::nonNull).map(String::toUpperCase).collect(Collectors.toList());
            return Files.readAllLines(logFile.toPath()).stream().map(this::getLogJsonContent).map(this::parseIpdLogEntry).map(IpdLogEntry::getLabel).anyMatch(ipdMetricNamesWithoutOnDemand::contains);
        }
        catch (IOException e) {
            throw new AssertionError("Couldn't read the IPD log file.", e);
        }
    }

    protected void cleanIpdLogFile() throws IOException {
        File logfile = new File(this.administration.getJiraHomeDirectory(), IPD_LOG_FILE_PATH);
        new PrintWriter(logfile).close();
    }

    private String getLogJsonContent(String logLine) {
        int index = StringUtils.ordinalIndexOf((String)logLine, (String)LOG_LINE_ELEMENTS_SEPARATOR, (int)3);
        return logLine.substring(index);
    }

    private IpdLogEntry parseIpdLogEntry(String jsonData) {
        try {
            return (IpdLogEntry)new ObjectMapper().readValue(jsonData, IpdLogEntry.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> getJmxObjectWithStats(String objectName) {
        return this.getJmxObject(objectName, JMX_STATS_ATTRIBUTES);
    }

    protected Map<String, Object> getJmxObjectWithValue(String objectName) {
        return this.getJmxObject(objectName, JMX_VALUE_ATTRIBUTE);
    }

    protected Map<String, Object> getRemotelyJmxObjectWithStats(String objectName) {
        return this.readRemotelyFromJmx(objectName, JMX_STATS_ATTRIBUTES, 10L, TimeUnit.SECONDS);
    }

    protected Map<String, Object> getRemotelyJmxObjectWithValue(String objectName) {
        return this.readRemotelyFromJmx(objectName, new String[]{JMX_VALUE_ATTRIBUTE}, 10L, TimeUnit.SECONDS);
    }

    private Map<String, Object> readRemotelyFromJmx(String name, String[] attributeNames, long timeout, TimeUnit unit) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Map> valuesFromJmx = executorService.submit(() -> {
            String host = this.environmentData.getBaseUrl().getHost();
            String url = "service:jmx:rmi:///jndi/rmi://" + host + ":" + 8199 + "/jmxrmi";
            JMXServiceURL serviceUrl = new JMXServiceURL(url);
            try (JMXConnector jmxConnector = JMXConnectorFactory.connect(serviceUrl, null);){
                MBeanServerConnection mbeanConn = jmxConnector.getMBeanServerConnection();
                Map<String, Object> map = mbeanConn.getAttributes(new ObjectName(name), attributeNames).asList().stream().collect(Collectors.toMap(a -> a.getName(), a -> a.getValue()));
                return map;
            }
        });
        try {
            return valuesFromJmx.get(timeout, unit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> getJmxObject(String objectName, String ... attributes) {
        try {
            return this.profilingControl.getMBeanAttributes(objectName, attributes);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatusInfo() == Response.Status.NOT_FOUND) {
                return null;
            }
            throw ex;
        }
    }

    protected String getMetricObjectName(String simpleName) {
        StringBuilder stringBuilder = new StringBuilder("com.atlassian.jira:type=metrics");
        String[] parts = simpleName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if (i == parts.length - 1) {
                stringBuilder.append(",name=").append(parts[i]);
                break;
            }
            stringBuilder.append(",category").append(String.format("%02d", i)).append("=").append(parts[i]);
        }
        return stringBuilder.toString();
    }

    protected String getMetricObjectName(String objectName, Map<String, String> tags) {
        String jmxObjectName = this.getMetricObjectName(objectName);
        if (tags == null || tags.isEmpty()) {
            return jmxObjectName;
        }
        jmxObjectName = jmxObjectName + "," + tags.entrySet().stream().map(e -> "tag." + (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
        return jmxObjectName;
    }

    protected List<IpdLogEntry> fetchIpdLogEntryWithRetry(String entryLabel) {
        File logfile = new File(this.administration.getJiraHomeDirectory(), IPD_LOG_FILE_PATH);
        return (List)Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.readOnDemandMetricsInIpdLogFile(logfile).stream().filter(e -> e.getLabel().equals(entryLabel)).sorted(Comparator.comparing(IpdLogEntry::getTimestamp).reversed()).collect(Collectors.toList()), e -> !e.isEmpty());
    }
}

