/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.util.mail.MailService;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdLogEntry;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.testcontainers.shaded.org.awaitility.Awaitility;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
@LoginAs(user="admin")
public class IncomingMailServerConnectionTest
extends BaseInProductDiagnosticsTest {
    private static final String CONNECTED_JMX_PARAM = "Connected";
    private static final String FAILURES_JMX_PARAM = "TotalFailures";
    private static final String CONNECTED_LOG_ENTRY_PARAM = "connected";
    private static final String TOTAL_FAILURES_LOG_ENTRY_PARAM = "totalFailures";
    private static final String CONNECTION_ENTRY_LABEL = "MAIL.INCOMING.CONNECTION.STATE.CUSTOM";
    private static final String INCOMING_CONNECTION_JMX_METRIC_NAME = "mail.incoming.connection.state.custom";
    private static final String SERVER_TAG_KEY = "serverName";
    private static final String SERVER_TAG_VALUE = "Local_Test_Imap_Server";
    @Inject
    private FuncTestLogger logger;

    @Before
    public void setUpp() throws IOException {
        this.mailService = new MailService(this.logger);
        this.cleanIpdLogFile();
        this.enableIPDFeature();
        this.enableIpdWipFeature();
    }

    @After
    public void after() {
        this.disableIPDFeature();
        this.disableIpdWipFeature();
        this.flushMailQueue();
        this.mailService.stop();
    }

    @Test
    @RestoreBlankInstance
    public void shouldSetValueToOneForWorkingConnectionToBasicMailServer() {
        String jmxObjectName = this.getMetricObjectName(INCOMING_CONNECTION_JMX_METRIC_NAME, (Map<String, String>)ImmutableMap.builder().put((Object)SERVER_TAG_KEY, (Object)SERVER_TAG_VALUE).build());
        Map<String, Object> totalFailures = this.getJmxObject(jmxObjectName, FAILURES_JMX_PARAM);
        this.configureAndStartImapServer();
        this.getBackdoor().getIpdControl().measure();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            Map<String, Object> jmxObject = this.getJmxObject(jmxObjectName, CONNECTED_JMX_PARAM);
            Assertions.assertThat(jmxObject).isNotEmpty();
            Assertions.assertThat((Object)jmxObject.get(CONNECTED_JMX_PARAM)).isEqualTo((Object)true);
            Assertions.assertThat(this.getJmxObject(jmxObjectName, FAILURES_JMX_PARAM)).isEqualTo((Object)totalFailures);
        });
        List<IpdLogEntry> entries = this.fetchIpdLogEntryWithRetry(CONNECTION_ENTRY_LABEL);
        Assertions.assertThat(entries).isNotEmpty();
        Assertions.assertThat(entries.get(0).getAttributes()).containsEntry((Object)CONNECTED_LOG_ENTRY_PARAM, (Object)"true");
    }

    @Test
    @RestoreBlankInstance
    public void shouldSetValueToZeroForFailingConnectionToBasicMailServer() {
        String jmxObjectName = this.getMetricObjectName(INCOMING_CONNECTION_JMX_METRIC_NAME, (Map<String, String>)ImmutableMap.builder().put((Object)SERVER_TAG_KEY, (Object)SERVER_TAG_VALUE).build());
        Map<String, Object> totalFailures = this.getJmxObject(jmxObjectName, FAILURES_JMX_PARAM);
        this.backdoor.mailServers().addPopServer("Local Test Imap Server", "Imap Server for test purposes", "imap", "localhost", 25143, "admin", "admin");
        this.getBackdoor().getIpdControl().measure();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            Map<String, Object> jmxObject = this.getJmxObject(jmxObjectName, CONNECTED_JMX_PARAM);
            Assertions.assertThat(jmxObject).isNotEmpty();
            Assertions.assertThat((Object)jmxObject.get(CONNECTED_JMX_PARAM)).isEqualTo((Object)false);
            Assertions.assertThat(this.getJmxObject(jmxObjectName, FAILURES_JMX_PARAM)).isNotEqualTo((Object)totalFailures);
        });
        List<IpdLogEntry> entries = this.fetchIpdLogEntryWithRetry(CONNECTION_ENTRY_LABEL);
        Assertions.assertThat(entries).isNotEmpty();
        ((MapAssert)Assertions.assertThat(entries.get(0).getAttributes()).containsEntry((Object)CONNECTED_LOG_ENTRY_PARAM, (Object)"false")).hasEntrySatisfying((Object)TOTAL_FAILURES_LOG_ENTRY_PARAM, value -> Assertions.assertThat((long)Long.parseLong(value)).isGreaterThan(0L));
    }

    @Override
    protected void configureAndStartImapServer() {
        super.configureAndStartImapServer();
        this.mailService.addUser("admin@stuff.com.com", "admin", "admin");
    }
}

