/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdLogEntry;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdMetricName;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
@LoginAs(user="admin")
@Restore(value="TestCommentNotifications.xml")
public class TestIpdMailJobRunning
extends BaseInProductDiagnosticsTest {
    @Before
    public void before() {
        this.enableIPDFeature();
        this.enableIpdWipFeature();
    }

    @After
    public void after() {
        this.disableIPDFeature();
        this.disableIpdWipFeature();
    }

    @Test
    @MailTest
    public void mailJobRunningAddedToIpdLogFile() throws IOException {
        this.cleanIpdLogFile();
        this.navigation.issue().addComment("TEST-1", "[~admin] [~fred]");
        this.backdoor.mailServers().flushMailQueue();
        List<IpdLogEntry> ipdLogEntries = this.readOnDemandMetricsInIpdLogFile();
        Assertions.assertThat((String)IpdMetricName.MAIL_JOB_RUNNING.getLastValueName()).isNotNull();
        List entriesWithoutMailJobRunning = ipdLogEntries.stream().filter(ipdLogEntry -> !ipdLogEntry.getLabel().equals(IpdMetricName.MAIL_JOB_RUNNING.getLastValueName().toUpperCase())).collect(Collectors.toList());
        List<IpdLogEntry> mailJobRunningEntries = ipdLogEntries.stream().filter(ipdLogEntry -> ipdLogEntry.getLabel().equals(IpdMetricName.MAIL_JOB_RUNNING.getLastValueName().toUpperCase())).collect(Collectors.toList());
        Assertions.assertThat(entriesWithoutMailJobRunning).isEmpty();
        Assertions.assertThat((int)mailJobRunningEntries.size()).isEqualTo(2);
        this.assertThatEntriesValuesAreDifferent(mailJobRunningEntries);
    }

    private void assertThatEntriesValuesAreDifferent(List<IpdLogEntry> mailJobRunningEntries) {
        HashSet<Long> possibleValues = new HashSet<Long>(Arrays.asList(1L, 0L));
        Set distinctMailJobRunningValues = mailJobRunningEntries.stream().map(entry -> Double.valueOf(entry.getAttributes().get("_value")).longValue()).collect(Collectors.toSet());
        Assertions.assertThat((int)mailJobRunningEntries.size()).isEqualTo(distinctMailJobRunningValues.size());
        Assertions.assertThat(possibleValues).isEqualTo(distinctMailJobRunningValues);
    }
}

