/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdLogEntry;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
@LoginAs(user="admin")
public class TestIpdMetricCollector
extends BaseInProductDiagnosticsTest {
    private static final Backdoor staticBackdoor = new Backdoor(LocalTestEnvironmentData.DEFAULT);

    @BeforeClass
    public static void before() {
        staticBackdoor.darkFeatures().enableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.featureKey()));
        staticBackdoor.darkFeatures().enableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS_WIP.featureKey()));
    }

    @AfterClass
    public static void after() {
        staticBackdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.featureKey()));
        staticBackdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS_WIP.featureKey()));
    }

    @Test
    public void allRegularlyLoggedMetricsFoundInLogFile() throws IOException {
        this.cleanIpdLogFile();
        List<IpdLogEntry> entries = this.readDistinctRegularLogMetricsInIpdLogFile();
        List metrics = this.getAllTypesMetricsWithoutOnDemand().map(String::toUpperCase).collect(Collectors.toList());
        for (String metric : metrics) {
            ((ListAssert)Assertions.assertThat(entries).withFailMessage("Metric %s not found in log file", new Object[]{metric})).anyMatch(entry -> entry.getLabel().equals(metric));
        }
    }

    @Test
    public void logFileContainsOnlyExpectedMetrics() throws IOException {
        List<IpdLogEntry> entries = this.readDistinctRegularLogMetricsInIpdLogFile();
        List regularMetrics = Stream.of(TestIpdMetricCollector.getStatsMetrics(), TestIpdMetricCollector.getLastValueMetrics(), TestIpdMetricCollector.getCounterMetrics(), TestIpdMetricCollector.getCustomMetrics()).reduce(Stream::concat).orElseGet(Stream::empty).map(String::toUpperCase).collect(Collectors.toList());
        List irregularMetrics = TestIpdMetricCollector.getIrregularMetrics().map(String::toUpperCase).collect(Collectors.toList());
        for (IpdLogEntry entry2 : entries) {
            if (irregularMetrics.contains(entry2.getLabel())) continue;
            ((ListAssert)Assertions.assertThat(regularMetrics).withFailMessage("Unexpected log metric %s", new Object[]{entry2.getLabel()})).anyMatch(metric -> entry2.getLabel().equals(metric));
            Assertions.assertThat((String)entry2.getObjectName()).isNull();
        }
        entries.stream().filter(entry -> entry.getLabel().endsWith("VALUE")).forEach(entry -> Assert.assertNotEquals((String)String.format("Unexpected log metric %s", entry.getLabel()), (double)-1.0, (double)Double.parseDouble(entry.getAttributes().get("_value")), (double)Double.MIN_NORMAL));
    }

    @Test
    public void logFileLastValueMetricsHaveExpectedArguments() throws IOException {
        List lastValueEntries = this.readDistinctRegularLogMetricsInIpdLogFile().stream().filter(entry -> entry.getLabel().endsWith(".VALUE")).collect(Collectors.toList());
        for (IpdLogEntry entry2 : lastValueEntries) {
            ((MapAssert)Assertions.assertThat(entry2.getAttributes()).as("Entry %s", new Object[]{entry2.getLabel()})).containsOnlyKeys((Object[])new String[]{"_value"});
        }
    }

    @Test
    public void logFileStatsMetricsHaveExpectedArguments() throws IOException {
        List lastValueEntries = this.readDistinctRegularLogMetricsInIpdLogFile().stream().filter(entry -> entry.getLabel().endsWith(".STATISTICS")).collect(Collectors.toList());
        for (IpdLogEntry entry2 : lastValueEntries) {
            ((MapAssert)Assertions.assertThat(entry2.getAttributes()).as("Entry %s", new Object[]{entry2.getLabel()})).containsOnlyKeys((Object[])SHORT_LOG_STATS_ATTRIBUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void logFileStatsMetricsExtraLoggingContainsAllInfo() throws IOException {
        this.enableIPDExtraLogging();
        this.cleanIpdLogFile();
        try {
            List statsEntries = this.readDistinctRegularLogMetricsInIpdLogFile().stream().filter(entry -> entry.getLabel().endsWith(".STATISTICS")).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(statsEntries).withFailMessage("IPD log file should contain at least one statistics metric.", new Object[0])).isNotEmpty();
            for (IpdLogEntry entry2 : statsEntries) {
                ((MapAssert)Assertions.assertThat(entry2.getAttributes()).as("Entry %s", new Object[]{entry2.getLabel()})).containsOnlyKeys((Object[])ALL_LOG_STATS_ATTRIBUTES);
                Assertions.assertThat((String)entry2.getObjectName()).isNotNull();
            }
        }
        finally {
            this.disableIPDExtraLogging();
            this.cleanIpdLogFile();
        }
    }
}

