/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.IpdMetricName;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
@LoginAs(user="admin")
@Restore(value="TestCommentNotifications.xml")
public class TestMailQueueItemsInProductDiagnosticJob
extends BaseInProductDiagnosticsTest {
    @Before
    public void before() {
        this.enableIPDFeature();
        this.enableIpdWipFeature();
    }

    @After
    public void after() {
        this.disableIPDFeature();
        this.disableIpdWipFeature();
    }

    @Test
    @MailTest
    public void mailQueueItemsEmittedToJMX() {
        this.backdoor.mailServers().flushMailQueue();
        this.navigation.issue().addComment("TEST-1", "[~admin] [~fred]");
        this.navigation.issue().addComment("TEST-1", "[~admin] [~fred] ");
        Awaitility.await().atMost(Duration.ONE_MINUTE).until(() -> {
            this.backdoor.getIpdControl().measure();
            Assertions.assertThat((double)this.getMetricLastValue(IpdMetricName.MAIL_QUEUE_ITEMS_ADDED.getLastValueName())).isGreaterThanOrEqualTo(2.0);
        });
    }

    @Test
    @MailTest
    public void mailQueueItemsProcessedEmittedToJMX() {
        this.backdoor.mailServers().flushMailQueue();
        this.navigation.issue().addComment("TEST-1", "[~admin] [~fred]");
        this.navigation.issue().addComment("TEST-1", "[~admin] [~fred] ");
        Awaitility.await().atMost(Duration.ONE_MINUTE).until(() -> {
            this.backdoor.mailServers().flushMailQueue();
            this.backdoor.getIpdControl().measure();
            Assertions.assertThat((double)this.getMetricLastValue(IpdMetricName.MAIL_QUEUE_ITEMS_PROCESSED.getLastValueName())).isGreaterThanOrEqualTo(2.0);
            Assertions.assertThat((double)this.getMetricLastValue(IpdMetricName.MAIL_QUEUE_EMAILS_SENT.getLastValueName())).isGreaterThanOrEqualTo(2.0);
        });
    }

    private double getMetricLastValue(String ipdMetricName) {
        String objectName = this.getMetricObjectName(ipdMetricName);
        Map<String, Object> metricsValue = this.getJmxObjectWithValue(objectName);
        return (Double)metricsValue.get("Value");
    }
}

