/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.sal;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.SalLicenseControl;
import com.atlassian.jira.functest.framework.backdoor.SingleProductLicenseDetailsViewTO;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.test.util.lic.LicenseReader;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class SalLicenseTest
extends BaseJiraRestTest {
    private static final License SOFTWARE_SUPER = SalLicenseTest.readLicense("software-super.lic");
    private static final License MULTIPLE_PRODUCTS = SalLicenseTest.readLicense("multiple-products.lic");
    private static final License SERVICE_DESK = SalLicenseTest.readLicense("service-desk.lic");
    private static final License CORE_AND_SOFTWARE = SalLicenseTest.readLicense("core-and-software.lic");
    private static final String CONFLUENCE_2000_EVALUATION = SalLicenseTest.readLicenseString("confluence-2000-evaluation.lic");
    private static final License SOFTWARE_ELA_SUBSCRIPTION = SalLicenseTest.readLicense("software-ela-subscription.lic");
    private static final License CORE_SOFT_INVALID_SD = SalLicenseTest.readLicense("core-soft-invalid-sd.lic");
    private static final License CORE_EXPIRED = SalLicenseTest.readLicense("core-expired.lic");
    private static final License STARTER_CORE_LICENSE = SalLicenseTest.readLicense("starter-core-license.lic");
    private static final License ACADEMIC_CORE_LICENSE = SalLicenseTest.readLicense("academic-core-license.lic");
    private static final License COMMUNITY_CORE_LICENSE = SalLicenseTest.readLicense("community-core-license.lic");
    private static final License SOFTWARE_SMALL_USER_COUNT = SalLicenseTest.readLicense("software-small-user-limit.lic");
    private SalLicenseControl salLicenseControl;

    private static License readLicense(String name) {
        String prefix = "/resources/" + SalLicenseTest.class.getPackage().getName().replace('.', '/');
        return LicenseReader.readLicense((String)(prefix + "/" + name), SalLicenseTest.class);
    }

    private static String readLicenseString(String name) {
        String prefix = "/resources/" + SalLicenseTest.class.getPackage().getName().replace('.', '/');
        return LicenseReader.readLicenseEncodedString((String)(prefix + "/" + name), SalLicenseTest.class);
    }

    @Before
    public void setUpTest() {
        this.salLicenseControl = new SalLicenseControl(this.environmentData);
    }

    public void prepareCleanInstance() {
        this.backdoor.license().replace(LicenseKeys.COMMERCIAL);
    }

    @Test
    public void testPing() {
        String response = this.salLicenseControl.ping();
        Assert.assertEquals((Object)"pong", (Object)response);
    }

    @Test
    public void testThatJiraAllowsCustomProducts() {
        Assert.assertTrue((boolean)this.salLicenseControl.hostAllowsCustomProducts());
    }

    @Test
    public void testThatJiraAllowsMultipleLicenses() {
        Assert.assertTrue((boolean)this.salLicenseControl.hostAllowsMultipleLicenses());
    }

    @Test
    public void testSEN() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        Assert.assertThat((Object)"TestSEN", (Matcher)Matchers.is((Object)this.salLicenseControl.getProductLicenseDetails((String)"jira-servicedesk").supportEntitlementNumber));
    }

    @Test
    public void testThatExistingLicenseIsRetrievableAsSoftwareLicense() {
        this.prepareCleanInstance();
        SingleProductLicenseDetailsViewTO softwareLicense = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicense);
        Assert.assertTrue((softwareLicense.numberOfUsers != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetrieveRawLicenseString() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        Assert.assertEquals((Object)StringUtils.remove((String)SERVICE_DESK.getLicenseString(), (String)"\n"), (Object)this.salLicenseControl.getRawProductLicense("jira-servicedesk"));
    }

    @Test
    public void testUnableToRemoveLastLicense() {
        this.backdoor.license().replace(SOFTWARE_SMALL_USER_COUNT);
        int initialLicenseCount = this.salLicenseControl.getProductKeys().size();
        Assert.assertEquals((long)1L, (long)initialLicenseCount);
        Boolean deleted = this.salLicenseControl.deleteProductLicense("jira-software");
        Assert.assertFalse((boolean)deleted);
        int licenseCount = this.salLicenseControl.getProductKeys().size();
        Assert.assertEquals((long)1L, (long)licenseCount);
    }

    @Test
    public void testRemoveProductLicense() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", CORE_AND_SOFTWARE));
        int licenseCount = this.salLicenseControl.getProductKeys().size();
        Assert.assertEquals((long)3L, (long)licenseCount);
        Boolean deleted = this.salLicenseControl.deleteProductLicense("jira-servicedesk");
        Assert.assertTrue((boolean)deleted);
        licenseCount = this.salLicenseControl.getProductKeys().size();
        Assert.assertEquals((long)2L, (long)licenseCount);
    }

    @Test
    public void testRetrieveRawLicenseStringMultiProducts() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", CORE_AND_SOFTWARE));
        Assert.assertEquals((Object)StringUtils.remove((String)SERVICE_DESK.getLicenseString(), (String)"\n"), (Object)this.salLicenseControl.getRawProductLicense("jira-servicedesk"));
        Assert.assertEquals((Object)StringUtils.remove((String)CORE_AND_SOFTWARE.getLicenseString(), (String)"\n"), (Object)this.salLicenseControl.getRawProductLicense("jira-software"));
        Assert.assertEquals((Object)StringUtils.remove((String)CORE_AND_SOFTWARE.getLicenseString(), (String)"\n"), (Object)this.salLicenseControl.getRawProductLicense("jira-core"));
    }

    @Test
    public void testDecodeLicenseString() {
        this.prepareCleanInstance();
        SalLicenseControl.MultiProductLicenseDetailsTO multiProductLicenseDetailsTO = this.salLicenseControl.decodeLicenseDetails(SERVICE_DESK);
        Assert.assertNotNull((Object)multiProductLicenseDetailsTO);
        Assert.assertEquals((long)1L, (long)multiProductLicenseDetailsTO.productLicenses.size());
        Assert.assertEquals((Object)"jira-servicedesk", (Object)multiProductLicenseDetailsTO.productLicenses.get((int)0).productKey);
        Assert.assertEquals((Object)"JIRA Enterprise: Commercial Server", (Object)multiProductLicenseDetailsTO.description);
    }

    @Test
    public void testDecodeLicenseStringWithMultipleProducts() {
        this.prepareCleanInstance();
        SalLicenseControl.MultiProductLicenseDetailsTO multiProductLicenseDetailsTO = this.salLicenseControl.decodeLicenseDetails(MULTIPLE_PRODUCTS);
        Assert.assertNotNull((Object)multiProductLicenseDetailsTO);
        Assert.assertEquals((long)3L, (long)multiProductLicenseDetailsTO.productLicenses.size());
        Assert.assertNotNull((Object)multiProductLicenseDetailsTO.getProductByKey("jira-core"));
        Assert.assertNotNull((Object)multiProductLicenseDetailsTO.getProductByKey("jira-servicedesk"));
        Assert.assertNotNull((Object)multiProductLicenseDetailsTO.getProductByKey("jira-software"));
        Assert.assertEquals((Object)"JIRA Enterprise: Commercial Server", (Object)multiProductLicenseDetailsTO.description);
    }

    @Test
    public void testSingleLicenseWithMultipleProducts() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", MULTIPLE_PRODUCTS));
        List<String> productKeys = this.salLicenseControl.getProductKeys();
        Assert.assertThat(Arrays.asList("jira-servicedesk", "jira-core", "jira-software"), (Matcher)Matchers.containsInAnyOrder((Object[])productKeys.toArray(new String[productKeys.size()])));
        Assert.assertEquals((long)1L, (long)this.salLicenseControl.getProductLicenseDetails((String)"jira-servicedesk").numberOfUsers);
        Assert.assertEquals((long)2L, (long)this.salLicenseControl.getProductLicenseDetails((String)"jira-core").numberOfUsers);
        Assert.assertEquals((long)3L, (long)this.salLicenseControl.getProductLicenseDetails((String)"jira-software").numberOfUsers);
        List<SalLicenseControl.MultiProductLicenseDetailsTO> allProductLicenses = this.salLicenseControl.getAllProductLicenses();
        Assert.assertEquals((long)1L, (long)allProductLicenses.size());
        Assert.assertEquals((Object)"JIRA Enterprise: Commercial Server", (Object)allProductLicenses.get((int)0).description);
        Assert.assertEquals((long)3L, (long)allProductLicenses.get((int)0).productLicenses.size());
    }

    @Test
    public void testMultipleLicenseWithMultipleProducts() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", CORE_AND_SOFTWARE));
        List<String> productKeys = this.salLicenseControl.getProductKeys();
        Assert.assertThat(Arrays.asList("jira-servicedesk", "jira-core", "jira-software"), (Matcher)Matchers.containsInAnyOrder((Object[])productKeys.toArray(new String[productKeys.size()])));
        Assert.assertEquals((long)5L, (long)this.salLicenseControl.getProductLicenseDetails((String)"jira-servicedesk").numberOfUsers);
        Assert.assertEquals((long)3L, (long)this.salLicenseControl.getProductLicenseDetails((String)"jira-core").numberOfUsers);
        Assert.assertEquals((long)4L, (long)this.salLicenseControl.getProductLicenseDetails((String)"jira-software").numberOfUsers);
        List<SalLicenseControl.MultiProductLicenseDetailsTO> allProductLicenses = this.salLicenseControl.getAllProductLicenses();
        Assert.assertEquals((long)2L, (long)allProductLicenses.size());
        Assert.assertEquals((Object)"JIRA Enterprise: Commercial Server", (Object)allProductLicenses.get((int)0).description);
    }

    @Test
    public void testBaseLicenseProperties() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", MULTIPLE_PRODUCTS));
        SalLicenseControl.MultiProductLicenseDetailsTO detailsTO = this.salLicenseControl.getAllProductLicenses().get(0);
        Assert.assertEquals((Object)"JIRA Enterprise: Commercial Server", (Object)detailsTO.description);
        Assert.assertEquals((Object)"Atlassian", (Object)detailsTO.organisationName);
        Assert.assertEquals((Object)"TestSEN", (Object)detailsTO.supportEntitlementNumber);
        Assert.assertEquals((Object)"COMMERCIAL", (Object)detailsTO.licenseTypeName);
        Assert.assertTrue((boolean)detailsTO.isDataCenter);
        Assert.assertFalse((boolean)detailsTO.isPerpetualLicense);
        Assert.assertEquals((long)3L, (long)detailsTO.productLicenses.size());
        Assert.assertFalse((boolean)detailsTO.isEnterpriseLicensingAgreement);
    }

    @Test
    public void testSuperLicense() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", SOFTWARE_SUPER));
        List<SalLicenseControl.MultiProductLicenseDetailsTO> allProductLicenses = this.salLicenseControl.getAllProductLicenses();
        for (SalLicenseControl.MultiProductLicenseDetailsTO productLicenseDetailsTO : allProductLicenses) {
            if (productLicenseDetailsTO.productLicenses.isEmpty()) continue;
            Assert.assertTrue((boolean)productLicenseDetailsTO.getProductByKey((String)"jira-software").isUnlimitedNumberOfUsers);
            Assert.assertFalse((boolean)productLicenseDetailsTO.isPerpetualLicense);
            Assert.assertFalse((boolean)productLicenseDetailsTO.isEnterpriseLicensingAgreement);
            return;
        }
        Assert.fail();
    }

    @Test
    public void testExpiredELALicense() {
        this.prepareCleanInstance();
        this.backdoor.license().set(SOFTWARE_ELA_SUBSCRIPTION);
        List<SalLicenseControl.MultiProductLicenseDetailsTO> allProductLicenses = this.salLicenseControl.getAllProductLicenses();
        for (SalLicenseControl.MultiProductLicenseDetailsTO productLicenseDetailsTO : allProductLicenses) {
            if (productLicenseDetailsTO.productLicenses.isEmpty()) continue;
            Assert.assertFalse((boolean)productLicenseDetailsTO.getProductByKey((String)"jira-software").isUnlimitedNumberOfUsers);
            Assert.assertTrue((boolean)productLicenseDetailsTO.isEnterpriseLicensingAgreement);
            return;
        }
        Assert.fail();
    }

    @Test
    public void testThatPreRenaissanceAreInterpretedAsSoftwareLicense() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-software", LicenseKeys.COMMERCIAL, Locale.ENGLISH);
        this.assertValidationResultValid(validationResultTO);
    }

    @Test
    public void testThatPreRenaissanceNotInterpretedAsNonSoftwareLicense() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-servicedesk", LicenseKeys.COMMERCIAL, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    @Test
    public void testPreRenaissanceReturnedAsSoftwareWhenMultiLicense() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        int licenseCount = this.salLicenseControl.getProductKeys().size();
        Assert.assertEquals((long)2L, (long)licenseCount);
        List<SalLicenseControl.MultiProductLicenseDetailsTO> allProductLicenses = this.salLicenseControl.getAllProductLicenses();
        Assert.assertEquals((long)2L, (long)allProductLicenses.size());
        SingleProductLicenseDetailsViewTO softwareLicense = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicense);
        Assert.assertTrue((softwareLicense.numberOfUsers != 0 ? 1 : 0) != 0);
        SingleProductLicenseDetailsViewTO serviceDeskLicense = this.salLicenseControl.getProductLicenseDetails("jira-servicedesk");
        Assert.assertNotNull((Object)serviceDeskLicense);
        Assert.assertTrue((serviceDeskLicense.numberOfUsers != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testThatSoftwareReplacesOnlyPreRenaissance() {
        this.prepareCleanInstance();
        SingleProductLicenseDetailsViewTO softwareLicense = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicense);
        int expected = -1;
        Assert.assertEquals((long)expected, (long)softwareLicense.numberOfUsers);
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-servicedesk", SERVICE_DESK));
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", SOFTWARE_SMALL_USER_COUNT));
        SingleProductLicenseDetailsViewTO softwareLicenseAfterReplace = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicenseAfterReplace);
        Assert.assertEquals((long)6L, (long)softwareLicenseAfterReplace.numberOfUsers);
        SingleProductLicenseDetailsViewTO serviceDeskLicenseAfterReplace = this.salLicenseControl.getProductLicenseDetails("jira-servicedesk");
        Assert.assertNotNull((Object)serviceDeskLicenseAfterReplace);
        Assert.assertEquals((long)5L, (long)serviceDeskLicenseAfterReplace.numberOfUsers);
    }

    @Test
    public void testThatPreRenaissanceLicenseReplacesSoftwareLicense() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", SOFTWARE_SMALL_USER_COUNT));
        SingleProductLicenseDetailsViewTO softwareLicenseAfterReplace = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicenseAfterReplace);
        Assert.assertEquals((long)6L, (long)softwareLicenseAfterReplace.numberOfUsers);
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", LicenseKeys.COMMERCIAL));
        SingleProductLicenseDetailsViewTO softwareLicenseAfterReplaceWithCommercial = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicenseAfterReplaceWithCommercial);
        int expected = -1;
        Assert.assertEquals((long)expected, (long)softwareLicenseAfterReplaceWithCommercial.numberOfUsers);
    }

    @Test
    public void testThatPreRenaissanceLicenseReplacesMultiSoftwareLicense() {
        this.prepareCleanInstance();
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", MULTIPLE_PRODUCTS));
        SingleProductLicenseDetailsViewTO softwareLicenseAfterReplace = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicenseAfterReplace);
        Assert.assertEquals((long)3L, (long)softwareLicenseAfterReplace.numberOfUsers);
        Assert.assertTrue((boolean)this.salLicenseControl.addProductLicense("jira-software", LicenseKeys.COMMERCIAL));
        SingleProductLicenseDetailsViewTO softwareLicenseAfterReplaceWithCommercial = this.salLicenseControl.getProductLicenseDetails("jira-software");
        Assert.assertNotNull((Object)softwareLicenseAfterReplaceWithCommercial);
        int expected = -1;
        Assert.assertEquals((long)expected, (long)softwareLicenseAfterReplaceWithCommercial.numberOfUsers);
    }

    @Test
    public void testValidLicense() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-software", SOFTWARE_SUPER, Locale.ENGLISH);
        this.assertValidationResultValid(validationResultTO);
    }

    @Test
    public void testLicenseNotForSpecifiedProduct() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-software", SERVICE_DESK, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    @Test
    public void testLicenseOtherThanJIRA() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-software", CONFLUENCE_2000_EVALUATION, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    @Test
    public void testRandomCharsAsLicense() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-software", "234yu2345onhoi231u4", Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    @Test
    public void testExpiredLicense() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-core", CORE_EXPIRED, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    @Test
    public void testUnsupportedV1License() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-core", LicenseKeys.V1_ENTERPRISE, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    @Test
    public void testSwitchingToStarterShouldBeOk() {
        this.prepareCleanInstance();
        this.salLicenseControl.validateLicenseString("jira-software", SOFTWARE_SUPER, Locale.ENGLISH);
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-core", STARTER_CORE_LICENSE, Locale.ENGLISH);
        this.assertValidationResultValid(validationResultTO);
    }

    @Test
    public void testSwitchingBetweenTypesIsPrevented() {
        this.prepareCleanInstance();
        this.salLicenseControl.validateLicenseString("jira-software", SOFTWARE_SUPER, Locale.ENGLISH);
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-core", COMMUNITY_CORE_LICENSE, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
        String actual = validationResultTO.getErrorMessages().iterator().next();
        Assert.assertThat((String)this.getMessageForValidationResult(validationResultTO), (Object)actual, (Matcher)Matchers.startsWith((String)"This license does not match the type of Jira currently licensed. This is a license for COMMUNITY Jira, which does not match your existing license for COMMERCIAL Jira. Please remove all other licenses for COMMERCIAL Jira if you'd like to change the type of your Jira instance."));
        java.util.regex.Matcher matcher = Pattern.compile("href=\"([^\"]+)\"").matcher(actual);
        if (matcher.find()) {
            String helpLink = matcher.group(1);
            Assert.assertThat((String)"Help link is not pointing at admin space", (Object)helpLink, (Matcher)Matchers.startsWith((String)"https://docs.atlassian.com/jira/jadm-docs-"));
            Assert.assertThat((String)"Help link is pointing to the wrong article", (Object)helpLink, (Matcher)Matchers.endsWith((String)"License+compatibility"));
        } else {
            Assert.fail((String)"Message did not provide a help link.");
        }
    }

    @Test
    public void testSingleLicenseKeyWithMultipleProductsServiceDeskInvalidUserLimit() {
        this.prepareCleanInstance();
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-software", CORE_SOFT_INVALID_SD, Locale.ENGLISH);
        this.assertValidationResultValid(validationResultTO);
        validationResultTO = this.salLicenseControl.validateLicenseString("jira-core", CORE_SOFT_INVALID_SD, Locale.ENGLISH);
        this.assertValidationResultValid(validationResultTO);
        validationResultTO = this.salLicenseControl.validateLicenseString("jira-servicedesk", CORE_SOFT_INVALID_SD, Locale.ENGLISH);
        this.assertValidationResultContainsSingleError(validationResultTO);
    }

    private void assertValidationResultValid(SalLicenseControl.ValidationResultTO validationResult) {
        Assert.assertTrue((String)this.getMessageForValidationResult(validationResult), (boolean)validationResult.isValid());
        Assert.assertFalse((String)this.getMessageForValidationResult(validationResult), (boolean)validationResult.hasErrors());
        Assert.assertFalse((String)this.getMessageForValidationResult(validationResult), (boolean)validationResult.hasWarnings());
        Assert.assertEquals((String)this.getMessageForValidationResult(validationResult), (long)0L, (long)Iterables.size(validationResult.getErrorMessages()));
        Assert.assertEquals((String)this.getMessageForValidationResult(validationResult), (long)0L, (long)Iterables.size(validationResult.getWarningMessages()));
    }

    private void assertValidationResultContainsSingleError(SalLicenseControl.ValidationResultTO validationResult) {
        Assert.assertFalse((String)this.getMessageForValidationResult(validationResult), (boolean)validationResult.isValid());
        Assert.assertTrue((String)this.getMessageForValidationResult(validationResult), (boolean)validationResult.hasErrors());
        Assert.assertFalse((String)this.getMessageForValidationResult(validationResult), (boolean)validationResult.hasWarnings());
        Assert.assertEquals((String)this.getMessageForValidationResult(validationResult), (long)1L, (long)Iterables.size(validationResult.getErrorMessages()));
        Assert.assertEquals((String)this.getMessageForValidationResult(validationResult), (long)0L, (long)Iterables.size(validationResult.getWarningMessages()));
    }

    private String getMessageForValidationResult(SalLicenseControl.ValidationResultTO validationResult) {
        StringBuilder stb = new StringBuilder();
        stb.append(validationResult.toString());
        stb.append("  Licensed products: ");
        stb.append(this.salLicenseControl.getProductKeys());
        return stb.toString();
    }
}

