/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.SimpleHttpHandler;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class HttpResponseTester
implements AutoCloseable {
    private final JIRAEnvironmentData environmentData;
    private final BlockingQueue<WebHookResponseData> responseQueue;
    private HttpServer server;
    private String path;
    private int port;

    public HttpResponseTester(JIRAEnvironmentData environmentData) {
        this(environmentData, 1);
    }

    public HttpResponseTester(JIRAEnvironmentData environmentData, int queueCapacity) {
        this.environmentData = environmentData;
        this.responseQueue = new ArrayBlockingQueue<WebHookResponseData>(queueCapacity);
    }

    public static HttpResponseTester createTester(JIRAEnvironmentData environmentData) {
        HttpResponseTester tester = new HttpResponseTester(environmentData);
        try {
            tester.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tester;
    }

    public void start() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(0), 0);
        SimpleHttpHandler handler = new SimpleHttpHandler(this.responseQueue);
        this.path = "/hook" + Math.random();
        this.port = this.server.getAddress().getPort();
        this.server.createContext(this.path, handler);
        this.server.setExecutor(null);
        this.server.start();
    }

    public void start(String path, int port) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        SimpleHttpHandler handler = new SimpleHttpHandler(this.responseQueue);
        this.server.createContext(path, handler);
        this.server.setExecutor(null);
        this.server.start();
    }

    public WebHookRegistrationClient.RegistrationResponse registerWebhook(WebHookRegistrationClient.Registration registration) {
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        int serverPort = this.server.getAddress().getPort();
        registration.url = "http://localhost:" + serverPort + this.path + (registration.path != null ? registration.path : "");
        return client.register(registration);
    }

    public WebHookResponseData getResponseData() throws InterruptedException {
        return this.responseQueue.poll(5L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.server.stop(0);
    }

    public String getPath() {
        return "http://localhost:" + this.port + this.path;
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }
}

