/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestIssueWebHook
extends BaseJiraFuncTest {
    public static final String ISSUE_UPDATED = "jira:issue_updated";
    private String issueKey;
    private CommentClient commentClient;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
        this.issueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"summary").key;
    }

    @Test
    public void testIssueUpdatedContainsIssueEventTypeWhenUpdatingIssue() throws Exception {
        this.webHooks.registerWebHook(ISSUE_UPDATED);
        this.backdoor.issues().addLabel(this.issueKey, "label");
        WebHookResponseData responseData = this.webHooks.getWebHookResponse();
        Assert.assertThat((Object)responseData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)responseData.asJsonObject().getString("issue_event_type_name"), (Matcher)Matchers.equalTo((Object)"issue_updated"));
    }

    @Test
    public void testIssueUpdatedFiresOnCommentCreate() throws Exception {
        this.webHooks.registerWebHook(ISSUE_UPDATED);
        String expected = "my-comment";
        this.backdoor.issues().commentIssue(this.issueKey, expected);
        this.checkResponseForWebHook(ISSUE_UPDATED, expected);
    }

    @Test
    public void testIssueUpdatedFiresOnCommentEdit() throws Exception {
        String expected = "my-comment";
        ParsedResponse commentResponse = this.backdoor.issues().commentIssue(this.issueKey, expected);
        this.webHooks.registerWebHook(ISSUE_UPDATED);
        this.commentClient.post(this.issueKey, (Comment)commentResponse.body);
        this.checkResponseForWebHook(ISSUE_UPDATED, expected);
    }

    @Test
    public void testIssueUpdatedFiresOnCommentDelete() throws Exception {
        ParsedResponse commentResponse = this.backdoor.issues().commentIssue(this.issueKey, "my-comment");
        this.webHooks.registerWebHook(ISSUE_UPDATED);
        this.commentClient.delete(this.issueKey, (Comment)commentResponse.body);
        this.checkResponseForWebHook(ISSUE_UPDATED, null);
    }

    @Test
    public void testIssueUpdatedFiresWhenUpdateIsWithoutNotifyingUsers() throws Exception {
        this.webHooks.registerWebHook(ISSUE_UPDATED);
        IssueUpdateRequest update = new IssueUpdateRequest().fields(new IssueFields().summary("new summary"));
        new IssueClient((JIRAEnvironmentData)this.getEnvironmentData()).updateResponse(this.issueKey, update, false);
        WebHookResponseData responseData = this.webHooks.getWebHookResponse();
        Assert.assertThat((Object)responseData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)responseData.asJsonObject().getString("issue_event_type_name"), (Matcher)Matchers.equalTo((Object)"issue_updated"));
    }

    private void checkResponseForWebHook(String eventName, String comment) throws Exception {
        WebHookResponseData responseData = this.webHooks.getWebHookResponse();
        Assert.assertThat((String)"Unexpected webhook event", (Object)this.webHooks.getResponseTester().getResponseData(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)responseData, (Matcher)Matchers.notNullValue());
        this.checkReturnedJson(eventName, comment, new JSONObject(responseData.getJson()));
    }

    private void checkReturnedJson(String eventName, String commentString, JSONObject event) throws JSONException {
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)eventName));
        JSONObject comment = event.optJSONObject("comment");
        if (commentString != null) {
            Assert.assertThat((Object)comment.getString("body"), (Matcher)Matchers.equalTo((Object)commentString));
        } else {
            Assert.assertNull((Object)comment);
        }
    }
}

