/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.BeforeBuildRule;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestProjectWebHook
extends BaseJiraFuncTest {
    public static final String projectName = "test";
    public static final String projectKey = "TEST";
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testProjectCreatedWebHook() throws Exception {
        String webHookName = "project_created";
        this.webHooks.registerWebHook("project_created");
        long projectId = this.createDefaultProject();
        this.checkResponseForWebHook("project_created", projectId);
    }

    @Test
    public void testProjectUpdatedWebHook() throws Exception {
        String webHookName = "project_updated";
        this.webHooks.registerWebHook("project_updated");
        long projectId = this.createDefaultProject();
        this.backdoor.project().setProjectLead(projectId, "fred");
        this.checkResponseForWebHook("project_updated", projectId);
    }

    @Test
    public void testProjectDeletedWebHook() throws Exception {
        String webHookName = "project_deleted";
        this.webHooks.registerWebHook("project_deleted");
        long projectId = this.createDefaultProject();
        this.backdoor.project().deleteProject(projectKey);
        this.checkResponseForWebHook("project_deleted", projectId);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=710000)
    public void testProjectArchivedWebHook() throws Exception {
        String webHookName = "project_archived";
        this.webHooks.registerWebHook("project_archived");
        long projectId = this.createDefaultProject();
        this.backdoor.project().archiveProject(projectKey);
        this.checkResponseForWebHook("project_archived", projectId);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=710000)
    public void testProjectRestoredWebHook() throws Exception {
        String webHookName = "project_restored";
        this.webHooks.registerWebHook("project_restored");
        long projectId = this.createDefaultProject();
        this.backdoor.project().archiveProject(projectKey);
        this.backdoor.project().restoreProject(projectKey);
        this.checkResponseForWebHook("project_restored", projectId);
    }

    @Test
    public void testWebHookRegisteredWithModuleDescriptor() throws Exception {
        String webHookName = "project_updated";
        String newLead = "fred";
        long projectId = this.createDefaultProject();
        this.backdoor.project().setProjectLead(projectId, "fred");
        JSONObject json = new JSONObject(this.webHooks.getWebHookResponseFromTestServlet("project_updated"));
        this.checkReturnedJson("project_updated", projectId, json);
        String returnedLead = json.getJSONObject("project").getJSONObject("projectLead").getString("name");
        Assert.assertThat((Object)returnedLead, (Matcher)Matchers.equalTo((Object)"fred"));
    }

    @Test
    @BeforeBuildRule.BeforeBuild(buildNumber=710000)
    public void testThatProjectWebHooksAreDistinguishable_preArchiving() throws Exception {
        this.validateMinorUpgradeCompliantProjectWebHooksAreDistinguishable(pid -> {});
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=710000)
    public void testThatProjectWebHooksAreDistinguishable() throws Exception {
        String projectArchivedWebHookName = "project_archived";
        String projectRestoredWebHookName = "project_restored";
        this.webHooks.registerWebHook("project_archived");
        this.webHooks.registerWebHook("project_restored");
        this.validateMinorUpgradeCompliantProjectWebHooksAreDistinguishable(projectId -> {
            this.backdoor.project().archiveProject(projectKey);
            this.checkResponseForWebHook("project_archived", (long)projectId);
            this.backdoor.project().restoreProject(projectKey);
            this.checkResponseForWebHook("project_restored", (long)projectId);
        });
    }

    public void validateMinorUpgradeCompliantProjectWebHooksAreDistinguishable(Consumer<Long> beforeProjectDeleted) throws Exception {
        String projectCreatedWebHookName = "project_created";
        String projectUpdatedWebHookName = "project_updated";
        String projectDeletedWebHookName = "project_deleted";
        this.webHooks.registerWebHook("project_created");
        this.webHooks.registerWebHook("project_updated");
        this.webHooks.registerWebHook("project_deleted");
        long projectId = this.createDefaultProject();
        this.checkResponseForWebHook("project_created", projectId);
        this.backdoor.project().setProjectLead(projectId, "fred");
        this.checkResponseForWebHook("project_updated", projectId);
        beforeProjectDeleted.accept(projectId);
        this.backdoor.project().deleteProject(projectKey);
        this.checkResponseForWebHook("project_deleted", projectId);
    }

    private long createDefaultProject() {
        return this.backdoor.project().addProject(projectName, projectKey, "admin");
    }

    private void checkResponseForWebHook(String eventName, long id) {
        try {
            WebHookResponseData responseData = this.webHooks.getWebHookResponse();
            Assert.assertThat((Object)responseData, (Matcher)Matchers.notNullValue());
            this.checkReturnedJson(eventName, id, new JSONObject(responseData.getJson()));
            Assert.assertThat((Object)this.webHooks.getResponseTester().getResponseData(), (Matcher)Matchers.nullValue());
        }
        catch (InterruptedException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkReturnedJson(String eventName, long id, JSONObject event) throws JSONException {
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)eventName));
        JSONObject project = event.getJSONObject("project");
        Assert.assertThat((Object)project.getLong("id"), (Matcher)Matchers.equalTo((Object)id));
        Assert.assertThat((Object)project.getString("key"), (Matcher)Matchers.equalTo((Object)projectKey));
        Assert.assertThat((Object)project.getString("name"), (Matcher)Matchers.equalTo((Object)projectName));
    }
}

