/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.VersionControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.VersionBean;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestVersionWebHook
extends BaseJiraFuncTest {
    private static final String VERSION_DESC = "Description";
    private static final String PROJECT_KEY = "MKY";
    private static final Random rand = new Random();
    public static final String JIRA_VERSION_DELETED_WEBHOOK_ID = "jira:version_deleted";
    private VersionControl versionControl;
    @Rule
    public WebHookTester webHooks = new WebHookTester();
    public final List<VersionTest> versionTests = ImmutableList.of((Object)new VersionTest("jira:version_created", () -> {
        this.webHooks.registerWebHook("jira:version_created");
        Version version = this.createVersion();
        return TestVersionWebHook.versionBeanFromVersion(version);
    }), (Object)new VersionTest("jira:version_released", () -> {
        this.webHooks.registerWebHook("jira:version_released");
        Version version = this.createVersion();
        Version updatedVersion = this.versionControl.releaseVersion(version.id);
        return TestVersionWebHook.versionBeanFromVersion(updatedVersion);
    }), (Object)new VersionTest("jira:version_unreleased", () -> {
        this.webHooks.registerWebHook("jira:version_unreleased");
        Version version = this.createVersion();
        this.versionControl.releaseVersion(version.id);
        this.versionControl.unreleaseVersion(version.id);
        return TestVersionWebHook.versionBeanFromVersion(version.released(Boolean.valueOf(false)));
    }), (Object)new VersionTest("jira:version_updated", () -> {
        this.webHooks.registerWebHook("jira:version_updated");
        Version version = this.createVersion();
        Version updatedVersion = this.versionControl.setDescription(version.id, "desc");
        return TestVersionWebHook.versionBeanFromVersion(updatedVersion);
    }), (Object)new VersionTest("jira:version_moved", () -> {
        this.webHooks.registerWebHook("jira:version_moved");
        Version version = this.createVersion();
        this.versionControl.moveVersion(version.id);
        return TestVersionWebHook.versionBeanFromVersion(version);
    }), (Object)new VersionTest("jira:version_deleted", () -> {
        this.webHooks.registerWebHook(JIRA_VERSION_DELETED_WEBHOOK_ID);
        Version version = this.createVersion();
        this.versionControl.deleteVersion(version.id);
        return TestVersionWebHook.versionBeanFromVersion(version);
    }));

    @Before
    public void setUpTest() {
        this.versionControl = new VersionControl(this.environmentData);
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testWebHookIsSentForVersionEvent() throws Exception {
        for (VersionTest versionTest : this.versionTests) {
            this.backdoor.restoreBlankInstance();
            VersionBean expectedValue = versionTest.performActionAndGetExpectedValue();
            WebHookEventVersionResult result = this.webHookEventVersionResult();
            Assert.assertEquals((String)("webhook id different for " + versionTest.getWebHookId()), (Object)versionTest.getWebHookId(), (Object)result.getWebhookEvent());
            Assert.assertEquals((String)("result different for " + versionTest.getWebHookId()), (Object)expectedValue, (Object)result.getVersion());
        }
    }

    @Test
    public void testUriVariablesAreCorrectlyProvidedForVersionWebHook() throws Exception {
        for (VersionTest versionTest : this.versionTests) {
            this.backdoor.restoreBlankInstance();
            VersionBean expectedValue = versionTest.performActionAndGetExpectedValue();
            JSONObject parameters = this.webHooks.getUrlParametersOfReceivedWebHook(versionTest.getWebHookId().replace("jira:", ""));
            Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"version_id").equalTo((Object)expectedValue.getId()));
            Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"project_key").equalTo((Object)PROJECT_KEY));
        }
    }

    @Test
    public void testWebHookIsSentForVersionMergeEvent() throws Exception {
        String webHookId = "jira:version_merged";
        this.webHooks.registerWebHook("jira:version_merged");
        Version fromVersion = this.createVersion();
        this.createIssueAndUpdateWithVersion(fromVersion, PROJECT_KEY);
        Version versionNew = this.createVersion();
        this.versionControl.mergeVersion(fromVersion.id, versionNew.id);
        VersionBean expectedValue = TestVersionWebHook.versionBeanFromVersion(versionNew);
        VersionBean expectedValueMerged = TestVersionWebHook.versionBeanFromVersion(fromVersion);
        WebHookEventVersionMergedResult result = this.webHooks.getWebHookResponseSupplier().get(WebHookEventVersionMergedResult.class);
        Assert.assertEquals((Object)"jira:version_merged", (Object)result.getWebhookEvent());
        Assert.assertEquals((Object)expectedValue, (Object)result.getVersion());
        Assert.assertEquals((Object)expectedValueMerged, (Object)result.getMergedVersion());
    }

    @Test
    public void testDeleteEventWithMergedInformationIsSentWhenPerformingMerge() throws Exception {
        this.webHooks.registerWebHook(JIRA_VERSION_DELETED_WEBHOOK_ID);
        Version fromVersion = this.createVersion();
        this.createIssueAndUpdateWithVersion(fromVersion, PROJECT_KEY);
        Version versionNew = this.createVersion();
        this.versionControl.mergeVersion(fromVersion.id, versionNew.id);
        VersionBean expectedValue = TestVersionWebHook.versionBeanFromVersion(fromVersion);
        VersionBean expectedValueMergedTo = TestVersionWebHook.versionBeanFromVersion(versionNew);
        WebHookEventVersionDeletedResult result = this.webHooks.getWebHookResponseSupplier().get(WebHookEventVersionDeletedResult.class);
        Assert.assertEquals((Object)JIRA_VERSION_DELETED_WEBHOOK_ID, (Object)result.getWebhookEvent());
        Assert.assertEquals((Object)expectedValue, (Object)result.getVersion());
        Assert.assertEquals((Object)expectedValueMergedTo, (Object)result.getAffectsVersionSwappedTo());
        Assert.assertEquals((Object)expectedValueMergedTo, (Object)result.getFixVersionSwappedTo());
    }

    @Test
    public void testUriVariablesAreCorrecttlyProvidedForVersionMergeEventWebHook() throws Exception {
        Version fromVersion = this.createVersion();
        this.createIssueAndUpdateWithVersion(fromVersion, PROJECT_KEY);
        Version versionNew = this.createVersion();
        this.versionControl.mergeVersion(fromVersion.id, versionNew.id);
        VersionBean expectedValue = TestVersionWebHook.versionBeanFromVersion(versionNew);
        VersionBean expectedValueMerged = TestVersionWebHook.versionBeanFromVersion(fromVersion);
        JSONObject parameters = this.webHooks.getUrlParametersOfReceivedWebHook("version_merged");
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"project_key").equalTo((Object)PROJECT_KEY));
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"mergedVersion_id").equalTo((Object)expectedValueMerged.getId()));
        Assert.assertThat((Object)parameters, (Matcher)JsonMatchers.hasField((String)"version_id").equalTo((Object)expectedValue.getId()));
    }

    @Test
    public void testFixVersionSetWhenVersionDeleted() throws Exception {
        this.webHooks.registerWebHook(JIRA_VERSION_DELETED_WEBHOOK_ID);
        Version versionToDelete = this.createVersion();
        Version fixVersionSwap = this.createVersion();
        Version affectsVersionSwap = this.createVersion();
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Test issue");
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().fixVersions(new ResourceRef[]{ResourceRef.withId((String)versionToDelete.id.toString())}));
        this.versionControl.delete(versionToDelete.id, fixVersionSwap.self, affectsVersionSwap.self);
        WebHookEventVersionDeletedResult result = this.webHooks.getWebHookResponseSupplier().get(WebHookEventVersionDeletedResult.class);
        Assert.assertEquals((Object)JIRA_VERSION_DELETED_WEBHOOK_ID, (Object)result.getWebhookEvent());
        Assert.assertEquals((Object)TestVersionWebHook.versionBeanFromVersion(versionToDelete), (Object)result.getVersion());
        Assert.assertEquals((Object)TestVersionWebHook.versionBeanFromVersion(fixVersionSwap), (Object)result.getFixVersionSwappedTo());
        Assert.assertEquals((Object)TestVersionWebHook.versionBeanFromVersion(affectsVersionSwap), (Object)result.getAffectsVersionSwappedTo());
    }

    private Version createVersion() {
        return this.versionControl.createVersion(String.valueOf(rand.nextLong()), VERSION_DESC, PROJECT_KEY);
    }

    private WebHookEventVersionResult webHookEventVersionResult() throws Exception {
        return this.webHooks.getWebHookResponseSupplier().get(WebHookEventVersionResult.class);
    }

    private Issue createIssueAndUpdateWithVersion(Version version, String projectKey) {
        String issueKey = this.backdoor.issues().createIssue(projectKey, "test summary").key();
        this.backdoor.issues().setIssueFields(issueKey, new IssueFields().versions(new ResourceRef[]{new ResourceRef().name(version.name)}));
        return this.backdoor.issues().getIssue(issueKey);
    }

    private static VersionBean versionBeanFromVersion(Version version) {
        return new VersionBean.Builder().setName(version.name).setDescription(version.description).setProjectId(version.projectId).setId(version.id).setSelf(URI.create(version.self)).setReleased(version.released).setOverdue(version.overdue == null ? false : version.overdue).build();
    }

    private class WebHookEventVersionDeletedResult
    extends WebHookEventVersionResult {
        VersionBean mergedTo;
        VersionBean affectsVersionSwappedTo;
        VersionBean fixVersionSwappedTo;

        private WebHookEventVersionDeletedResult() {
        }

        public VersionBean getMergedTo() {
            return this.mergedTo;
        }

        public void setMergedTo(VersionBean mergedTo) {
            this.mergedTo = mergedTo;
        }

        public VersionBean getAffectsVersionSwappedTo() {
            return this.affectsVersionSwappedTo;
        }

        public void setAffectsVersionSwappedTo(VersionBean affectsVersionSwappedTo) {
            this.affectsVersionSwappedTo = affectsVersionSwappedTo;
        }

        public VersionBean getFixVersionSwappedTo() {
            return this.fixVersionSwappedTo;
        }

        public void setFixVersionSwappedTo(VersionBean fixVersionSwappedTo) {
            this.fixVersionSwappedTo = fixVersionSwappedTo;
        }
    }

    private class WebHookEventVersionMergedResult
    extends WebHookEventVersionResult {
        VersionBean mergedVersion;

        private WebHookEventVersionMergedResult() {
        }

        public VersionBean getMergedVersion() {
            return this.mergedVersion;
        }

        public void setMergedVersion(VersionBean mergedVersion) {
            this.mergedVersion = mergedVersion;
        }
    }

    private class WebHookEventVersionResult {
        long timestamp;
        String webhookEvent;
        VersionBean version;

        private WebHookEventVersionResult() {
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getWebhookEvent() {
            return this.webhookEvent;
        }

        public void setWebhookEvent(String webhookEvent) {
            this.webhookEvent = webhookEvent;
        }

        public VersionBean getVersion() {
            return this.version;
        }

        public void setVersion(VersionBean version) {
            this.version = version;
        }
    }

    private static class VersionTest {
        private final String webHookId;
        private final Callable<VersionBean> expectedValueCallable;

        private VersionTest(String webHookId, Callable<VersionBean> expectedValueCallable) {
            this.webHookId = webHookId;
            this.expectedValueCallable = expectedValueCallable;
        }

        public String getWebHookId() {
            return this.webHookId;
        }

        public VersionBean performActionAndGetExpectedValue() throws Exception {
            return this.expectedValueCallable.call();
        }
    }
}

