/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import org.hamcrest.Matcher;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestWebHookEncoding
extends BaseJiraFuncTest {
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Test
    public void testUTF8Encoding() throws InterruptedException, JSONException {
        this.backdoor.restoreBlankInstance();
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Comment Issue Web Hook";
        registration.events = new String[]{"jira:issue_updated", "jira:issue_created"};
        this.webHooks.getResponseTester().registerWebhook(registration);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "This is issue with utf-8 chars \u00c4\u008d\u00c5\u00a1\u00c5\u00be\u00c4\u0087\u00c4\u0091");
        JSONObject event = new JSONObject(this.webHooks.getWebHookResponse().getJson());
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"issue.fields.summary"));
        Assert.assertEquals((Object)"This is issue with utf-8 chars \u00c4\u008d\u00c5\u00a1\u00c5\u00be\u00c4\u0087\u00c4\u0091", (Object)event.getJSONObject("issue").getJSONObject("fields").getString("summary"));
        this.backdoor.issues().setDescription(issue.key(), "Description with \u00c4\u009f\u00c4\u009e\u00c3\u00a7\u00c3\u00bc\u00c3\u00b6\u00c4\u00b0\u00c4\u00b1\u00c3\u0096");
        JSONObject updateEvent = new JSONObject(this.webHooks.getWebHookResponse().getJson());
        Assert.assertThat((Object)updateEvent, (Matcher)JsonMatchers.hasField((String)"issue.fields.description"));
        Assert.assertEquals((Object)"Description with \u00c4\u009f\u00c4\u009e\u00c3\u00a7\u00c3\u00bc\u00c3\u00b6\u00c4\u00b0\u00c4\u00b1\u00c3\u0096", (Object)updateEvent.getJSONObject("issue").getJSONObject("fields").getString("description"));
    }
}

