/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookListener;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.WebHookMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
@Restore(value="TestWebHooks.zip")
public class TestWebHookUpgradeTask
extends BaseJiraFuncTest {
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Test
    public void testUpgradingWebHooks() {
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        List<WebHookRegistrationClient.RegistrationResponse> allWebHooks = client.getAllWebHooks();
        String[] allEvents = new String[]{"jira:issue_created", "jira:issue_deleted", "jira:issue_updated", "jira:worklog_updated"};
        Assert.assertEquals((String)"All WebHooks should have been upgraded", (long)7L, (long)allWebHooks.size());
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHooks without details", "http://localhost:500/${issue.key}/no-details", new String[]{"jira:issue_created"}, "", true, 6)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHook with simple JQL", "http://localhost:100", new String[]{"jira:issue_created"}, "project = DEMO AND issuetype = Bug", false, 5)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHook without details and with filter", "https://localhost:600", allEvents, "issuetype = Improvement", true, 7)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHook with transitions", "http://localhost:700", allEvents, "", true, 8)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHook no events", "http://localhost:400/no-events/${issue.key}", allEvents, "", false, 2)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHook with exclude and transition", "http://localhost:200", allEvents, "", true, 1)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("WebHook some events only", "http://localhost:300/${issue.key}", new String[]{"jira:issue_deleted", "jira:issue_updated"}, "project = Demonstration", false, 3)));
        WebHookRegistrationClient.Registration newRegistration = new WebHookRegistrationClient.Registration();
        newRegistration.events = allEvents;
        newRegistration.setFilterForIssueSection("project = DEMO");
        newRegistration.url = "http://localhost:900";
        newRegistration.name = "WebHook added after import";
        client.register(newRegistration);
        WebHookRegistrationClient.RegistrationResponse webHook = client.getWebHook("9");
        Assert.assertThat(Collections.singletonList(webHook), WebHookMatchers.containsWebHook(new WebHookListener("WebHook added after import", "http://localhost:900", allEvents, "project = DEMO", false, 9)));
    }
}

