/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookListener;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.WebHookMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
@Restore(value="TestVersionWebHooks.zip")
public class TestWebHookUpgradeTaskForVersion
extends BaseJiraFuncTest {
    private static final String[] allEvents = new String[]{"jira:issue_created", "jira:issue_updated", "jira:issue_deleted", "jira:worklog_updated", "user_created", "user_deleted", "version_created", "version_released", "version_unreleased", "version_moved", "version_updated", "version_merged", "version_deleted", "project_created", "project_deleted", "project_updated", "option_attachments_changed", "option_issuelinks_changed", "option_timetracking_changed", "option_subtasks_changed", "option_unassigned_issues_changed", "option_watching_changed", "option_voting_changed"};
    private static final String[] versionEvents = new String[]{"version_created", "version_deleted", "version_merged", "version_updated", "version_moved", "version_released", "version_unreleased"};
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Test
    public void testUpgradingVersionWebHooks() {
        WebHookRegistrationClient client = new WebHookRegistrationClient(this.environmentData);
        List<WebHookRegistrationClient.RegistrationResponse> allWebHooks = client.getAllWebHooks();
        Assert.assertEquals((String)"All WebHooks should have been restored", (long)3L, (long)allWebHooks.size());
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("Empty Webhook", "http://example.com/rest/webhooks/webhook1", new String[0], "", false, 1)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("Only Version Webhook", "http://example.com/rest/webhooks/webhook1", versionEvents, "", false, 3)));
        Assert.assertThat(allWebHooks, WebHookMatchers.containsWebHook(new WebHookListener("All Events Webhook", "http://example.com/rest/webhooks/webhook1", allEvents, "", false, 2)));
    }
}

