/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestWebhookUsernameAnonymization
extends BaseJiraFuncTest {
    @Rule
    public WebHookTester webHooks = new WebHookTester();
    private WebHookRegistrationClient webHookRegistrationClient;
    private UserAnonymizeControl userAnonymizeControl;

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.getEnvironmentData());
        this.backdoor.restoreBlankInstance();
        this.webHookRegistrationClient = new WebHookRegistrationClient(new BackdoorModule().getEnvironmentData());
    }

    @Test
    public void givenWebhookLastEditedByUserWhenAnonymizeThenUsernameChanged() {
        this.backdoor.permissions().addGlobalPermission(0, "jira-users");
        this.registerWebHookAsUser("user_created", "fred");
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        List<WebHookRegistrationClient.RegistrationResponse> webhooks = this.webHooks.getAllWebhooks();
        Optional<WebHookRegistrationClient.RegistrationResponse> theWebhook = webhooks.stream().filter(webhook -> "Test webHook".equals(webhook.name)).findFirst();
        Assert.assertTrue((boolean)theWebhook.isPresent());
        MatcherAssert.assertThat((Object)theWebhook.get().lastUpdatedUser, (Matcher)CoreMatchers.is((Object)anonymizeResult.getUserNameNew()));
    }

    private void registerWebHookAsUser(String webHook, String username) {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Test webHook";
        registration.events = new String[]{webHook};
        registration.url = "http://www.test.com";
        ((WebHookRegistrationClient)this.webHookRegistrationClient.loginAs(username)).register(registration);
    }
}

