/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestWorklogWebHook
extends BaseJiraFuncTest {
    protected static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final long DEFAULT_SCHEME_ID = 0L;
    protected WorklogClient worklogClient;
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_WORKLOGS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.DELETE_OWN_WORKLOGS);
    }

    @Test
    public void testWorklogWebHooksWithJQL() throws Exception {
        IssueCreateResponse issue = this.createIssue();
        IssueCreateResponse issue_filtered = this.createIssue();
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Worklog created with filtering";
        registration.events = new String[]{"worklog_created", "worklog_updated", "worklog_deleted"};
        registration.setFilterForIssueSection("key = \"" + issue.key + "\"");
        this.webHooks.getResponseTester().registerWebhook(registration);
        Worklog worklog_filtered = this.createWorklog(issue_filtered);
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        Worklog worklog = this.createWorklog(issue);
        Assert.assertNotNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.updateWorklog(issue_filtered, worklog_filtered);
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.updateWorklog(issue, worklog);
        Assert.assertNotNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.deleteWorklog(issue_filtered, worklog_filtered);
        Assert.assertNull((Object)this.webHooks.getResponseTester().getResponseData());
        this.deleteWorklog(issue, worklog);
        Assert.assertNotNull((Object)this.webHooks.getResponseTester().getResponseData());
    }

    @Test
    public void testWorklogCreatedWebHook() throws Exception {
        String webHookName = "worklog_created";
        this.webHooks.registerWebHook("worklog_created");
        IssueCreateResponse issue = this.createIssue();
        Worklog worklog = this.createWorklog(issue);
        this.checkResponseForWebHook("worklog_created", worklog);
    }

    @Test
    public void testWorklogUpdatedWebHook() throws Exception {
        String webHookName = "worklog_updated";
        this.webHooks.registerWebHook("worklog_updated");
        IssueCreateResponse issue = this.createIssue();
        Worklog worklog = this.createWorklog(issue);
        Worklog updatedWorklog = this.updateWorklog(issue, worklog);
        this.checkResponseForWebHook("worklog_updated", updatedWorklog);
    }

    @Test
    public void testWorklogDeletedWebHook() throws Exception {
        String webHookName = "worklog_deleted";
        this.webHooks.registerWebHook("worklog_deleted");
        IssueCreateResponse issue = this.createIssue();
        Worklog worklog = this.createWorklog(issue);
        this.deleteWorklog(issue, worklog);
        this.checkResponseForWebHook("worklog_deleted", worklog);
    }

    @Test
    public void testWorklogWebHookWorksWhenRegisteredWithModuleDescriptor() throws Exception {
        String webHookCreatedName = "worklog_created";
        String webHookUpdatedName = "worklog_updated";
        String webHookDeletedName = "worklog_deleted";
        IssueCreateResponse issue = this.createIssue();
        Worklog worklog = this.createWorklog(issue);
        this.checkWebHookNameRegisteredInModuleDescriptor("worklog_created", worklog);
        Worklog updatedWorklog = this.updateWorklog(issue, worklog);
        this.checkWebHookNameRegisteredInModuleDescriptor("worklog_updated", updatedWorklog);
        this.deleteWorklog(issue, worklog);
        this.checkWebHookNameRegisteredInModuleDescriptor("worklog_deleted", updatedWorklog);
    }

    @Test
    public void testWorklogUpdatedInIssue() throws Exception {
        String webHookName = "jira:worklog_updated";
        this.webHooks.registerWebHook("jira:worklog_updated");
        IssueCreateResponse issue = this.createIssue();
        Worklog worklog = this.createWorklog(issue);
        this.checkWebHookName("jira:worklog_updated");
        this.updateWorklog(issue, worklog);
        this.checkWebHookName("jira:worklog_updated");
        this.deleteWorklog(issue, worklog);
        this.checkWebHookName("jira:worklog_updated");
    }

    @Test
    public void testWorklogDeletedWebHooksSentWhenIssueDeleted() throws Exception {
        String webHookName = "worklog_deleted";
        this.webHooks.registerWebHook("worklog_deleted");
        IssueCreateResponse issue = this.createIssue();
        Worklog worklog = this.createWorklog(issue);
        this.backdoor.issues().deleteIssue(issue.key, true);
        this.checkResponseForWebHook("worklog_deleted", worklog);
    }

    private IssueCreateResponse createIssue() {
        return this.backdoor.issues().createIssue("HSP", "Issue summary");
    }

    protected Worklog createWorklog(IssueCreateResponse issue) {
        Worklog worklog = new Worklog();
        worklog.started = new SimpleDateFormat(TIME_FORMAT).format(new Date());
        worklog.timeSpent = "1h";
        worklog.comment = "comment";
        return (Worklog)this.worklogClient.post((String)issue.key, (Worklog)worklog).body;
    }

    private Worklog updateWorklog(IssueCreateResponse issue, Worklog worklog) {
        worklog.comment = "new comment";
        worklog.timeSpentSeconds = null;
        return (Worklog)this.worklogClient.put((String)issue.key, (Worklog)worklog).body;
    }

    private void deleteWorklog(IssueCreateResponse issue, Worklog worklog) {
        this.worklogClient.delete(issue.key, worklog);
    }

    private void checkResponseForWebHook(String eventName, Worklog worklog) throws Exception {
        JSONObject event = this.getWebHookResponseDataFromDataBase();
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)eventName));
        WorklogJsonBean worklogFromWebHook = (WorklogJsonBean)new Gson().fromJson(event.getJSONObject("worklog").toString(), WorklogJsonBean.class);
        Assert.assertThat((Object)worklogFromWebHook, TestWorklogWebHook.isWorklog(worklog));
    }

    private void checkWebHookNameRegisteredInModuleDescriptor(String eventName, Worklog worklog) throws JSONException {
        JSONObject event = new JSONObject(this.webHooks.getWebHookResponseFromTestServlet(eventName));
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)eventName));
        WorklogJsonBean worklogFromWebHook = (WorklogJsonBean)new Gson().fromJson(event.getJSONObject("worklog").toString(), WorklogJsonBean.class);
        Assert.assertThat((Object)worklogFromWebHook, TestWorklogWebHook.isWorklog(worklog));
    }

    private void checkWebHookName(String eventName) throws Exception {
        JSONObject event = this.getWebHookResponseDataFromDataBase();
        Assert.assertThat((Object)event, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)eventName));
    }

    private JSONObject getWebHookResponseDataFromDataBase() throws Exception {
        WebHookResponseData responseData = this.webHooks.getWebHookResponse();
        Assert.assertThat((Object)responseData, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.webHooks.getResponseTester().getResponseData(), (Matcher)Matchers.nullValue());
        return new JSONObject(responseData.getJson());
    }

    public static Matcher<WorklogJsonBean> isWorklog(final Worklog worklog) {
        return new TypeSafeMatcher<WorklogJsonBean>(){

            protected boolean matchesSafely(WorklogJsonBean item) {
                return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)worklog.id)), Matchers.hasProperty((String)"issueId", (Matcher)Matchers.equalTo((Object)worklog.issueId)), Matchers.hasProperty((String)"comment", (Matcher)Matchers.equalTo((Object)worklog.comment)), Matchers.hasProperty((String)"updated", (Matcher)TestWorklogWebHook.equalAsLocalDate(Dates.fromTimeString((String)worklog.updated))), Matchers.hasProperty((String)"created", (Matcher)TestWorklogWebHook.equalAsLocalDate(Dates.fromTimeString((String)worklog.created))), Matchers.hasProperty((String)"started", (Matcher)TestWorklogWebHook.equalAsLocalDate(Dates.fromTimeString((String)worklog.started))), Matchers.hasProperty((String)"timeSpent", (Matcher)Matchers.equalTo((Object)worklog.timeSpent))}).matches((Object)item);
            }

            public void describeTo(Description description) {
                description.appendText(String.format("(id=%s, author=%s, updateAuthor=%s, comment=%s, updated=%s, created=%s, started=%s, timeSpent=%s)", worklog.id, worklog.author, worklog.updateAuthor, worklog.comment, worklog.updated, worklog.created, worklog.started, worklog.timeSpent));
            }
        };
    }

    private static Matcher<Date> equalAsLocalDate(final Date date) {
        return new TypeSafeMatcher<Date>(){

            protected boolean matchesSafely(Date item) {
                return TestWorklogWebHook.toLocalState(item).equals(TestWorklogWebHook.toLocalState(date));
            }

            public void describeTo(Description description) {
                SimpleDateFormat format = new SimpleDateFormat(TestWorklogWebHook.TIME_FORMAT);
                description.appendText(format.format(date));
            }
        };
    }

    private static LocalDate toLocalState(Date date) {
        Instant instant = Instant.ofEpochMilli(date.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
    }
}

