/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.framework.backdoor.VersionControl;
import com.atlassian.jira.functest.framework.backdoor.webhooks.WebHookRegistrationClient;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.HttpResponseTester;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookResponseData;
import com.google.common.base.Supplier;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WebHookTester
implements TestRule {
    private static final Gson GSON = new Gson();
    private final JIRAEnvironmentData environmentData = new BackdoorModule().getEnvironmentData();
    private final VersionControl versionControl = new VersionControl(this.environmentData);
    private final HttpResponseTester responseTester = HttpResponseTester.createTester(this.environmentData);
    private final List<HttpResponseTester> cleanup = new ArrayList<HttpResponseTester>();
    private final WebHookResponseSupplier webHookResponseSupplier = new WebHookResponseSupplier();
    private WebHookRegistrationClient webHookRegistrationClient = new WebHookRegistrationClient(this.environmentData);

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WebHookTester.this.setUp();
                try {
                    base.evaluate();
                }
                finally {
                    WebHookTester.this.stopHttpResponseTesters();
                }
            }
        };
    }

    public void setUp() {
        this.cleanup.add(this.responseTester);
        this.cleanReceivedWebHookQueue();
    }

    private void cleanReceivedWebHookQueue() {
        HttpClient client = new HttpClient(new HttpClientParams());
        try {
            client.executeMethod((HttpMethod)new DeleteMethod(this.getWebHookUri().toString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void stopHttpResponseTesters() {
        for (HttpResponseTester httpResponseTester : this.cleanup) {
            httpResponseTester.stop();
        }
    }

    void addToCleanupList(HttpResponseTester tester) {
        this.cleanup.add(tester);
    }

    final Supplier<String> receiveWebhook(String webHookPath) {
        return () -> this.getWebHookResponseFromTestServlet(webHookPath);
    }

    public void registerWebHook(String webHook) {
        WebHookRegistrationClient.Registration registration = new WebHookRegistrationClient.Registration();
        registration.name = "Test webHook";
        registration.events = new String[]{webHook};
        this.responseTester.registerWebhook(registration);
    }

    public List<WebHookRegistrationClient.RegistrationResponse> getAllWebhooks() {
        return this.webHookRegistrationClient.getAllWebHooks();
    }

    private URI getWebHookUri() {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.environmentData.getBaseUrl().toExternalForm());
        Stream.of("plugins", "servlet", "jiraWebHook").forEach(arg_0 -> ((UriBuilder)uriBuilder).path(arg_0));
        return uriBuilder.build(new Object[0]);
    }

    WebHookResponseData getWebHookResponse() {
        try {
            return this.responseTester.getResponseData();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    WebHookResponseData getWebHookResponseFromReferencePlugin(String webHookId) {
        String responseFromTestServlet = this.getWebHookResponseFromTestServlet(webHookId);
        return new WebHookResponseData(responseFromTestServlet, this.getWebHookFromReferencePluginUri(this.getWebHookUri(), webHookId));
    }

    String getWebHookResponseFromTestServlet(String webHookId) {
        return this.getFromServlet(this.getWebHookUri(), webHookId);
    }

    private String getFromServlet(URI uri, String webHookPath) {
        HttpClient client = new HttpClient(new HttpClientParams());
        GetMethod getMethod = new GetMethod(this.getWebHookFromReferencePluginUri(uri, webHookPath).toString());
        try {
            client.executeMethod((HttpMethod)getMethod);
            return getMethod.getResponseBodyAsString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URI getWebHookFromReferencePluginUri(URI url, String webHookPath) {
        return UriBuilder.fromUri((URI)url).queryParam("bucket", new Object[]{webHookPath}).build(new Object[0]);
    }

    JSONObject getUrlParametersOfReceivedWebHook(String webHookPath) throws JSONException {
        URI uri = UriBuilder.fromUri((URI)this.getWebHookUri()).queryParam("params", new Object[]{true}).build(new Object[0]);
        return new JSONObject(this.getFromServlet(uri, webHookPath));
    }

    HttpResponseTester getResponseTester() {
        return this.responseTester;
    }

    WebHookResponseSupplier getWebHookResponseSupplier() {
        return this.webHookResponseSupplier;
    }

    VersionControl getVersionControl() {
        return this.versionControl;
    }

    protected class WebHookResponseSupplier
    implements Supplier<String> {
        protected WebHookResponseSupplier() {
        }

        public <T> T get(Class<T> theClass) {
            String jsonString = this.get();
            return (T)GSON.fromJson(jsonString, theClass);
        }

        public String get() {
            return WebHookTester.this.getWebHookResponse().getJson();
        }
    }
}

