/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.cache;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.vcache.PutPolicy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class VCacheSmokeTest
extends BaseJiraFuncTest {
    private static final String CACHE_NAME = "funcTestCache";

    @Before
    public void setup() {
        this.backdoor.vCacheControl().cleanall(CACHE_NAME);
    }

    @Test
    public void canAddAndRetrieveValuesFromExternalDirectCache() {
        boolean result = this.backdoor.vCacheControl().putValueToDirectCache(CACHE_NAME, "key1", PutPolicy.ADD_ONLY, "someValue");
        String value = this.backdoor.vCacheControl().getValueFromDirectCache(CACHE_NAME, "key1");
        Assert.assertTrue((String)"value for 'key1' hasn't been added", (boolean)result);
        MatcherAssert.assertThat((Object)value, (Matcher)Is.is((Object)"someValue"));
    }

    @Test
    public void valuesInRequestCacheAreClearedAfterEachRequest() {
        this.backdoor.vCacheControl().putValueToRequestCache(CACHE_NAME, "key1", "someValue");
        String value = this.backdoor.vCacheControl().getValueFromRequestCache(CACHE_NAME, "key1");
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.isEmptyOrNullString());
    }
}

