/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.ServicesControl;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.icegreen.greenmail.store.FolderException;
import java.io.IOException;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
@LoginAs(user="admin")
@Restore(value="TestCommentNotifications.xml")
public class TestCommentNotifications
extends EmailBaseFuncTestCase {
    private static final String ISSUE_KEY = "TEST-1";
    private static final String FRED_USERNAME = "fred";
    private static final String FRED_FULLNAME = "Fred User";
    private static final String FRED_EMAIL = "fred@localhost";
    private static final String TED_USERNAME = "ted";
    private static final String TED_FULLNAME = "Ted User";
    private static final String TED_EMAIL = "ted@localhost";
    private static final String ADMIN_EMAIL = "admin@localhost";

    @Before
    public void setUpTest() {
        this.configureAndStartSmtpServer();
    }

    @Test
    public void testAddCommentSendsEmailWithFullNames() throws InterruptedException, FolderException, MessagingException, IOException {
        this.backdoor.permissions().removeGlobalPermission(27, "jira-developers");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-users");
        this.backdoor.permissions().addGlobalPermission(27, "jira-administrators");
        this.backdoor.usersAndGroups().addUser(FRED_USERNAME, FRED_USERNAME, FRED_FULLNAME, FRED_EMAIL, false);
        this.backdoor.usersAndGroups().addUser(TED_USERNAME, TED_USERNAME, TED_FULLNAME, TED_EMAIL, false);
        this.backdoor.usersAndGroups().addUserToGroup(TED_USERNAME, "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup(FRED_USERNAME, "jira-developers");
        this.backdoor.issues().assignIssue(ISSUE_KEY, TED_USERNAME);
        this.mailService.addUser(TED_EMAIL, TED_EMAIL, TED_EMAIL);
        this.mailService.addUser(FRED_EMAIL, FRED_EMAIL, FRED_EMAIL);
        this.mailService.addUser(ADMIN_EMAIL, ADMIN_EMAIL, ADMIN_EMAIL);
        this.flushMailQueueAndWait(2);
        this.mailService.removeAllReceivedMessages();
        this.addCommentOnIssue();
        this.flushMailQueue();
        this.assertAddedCommentNotifications();
        this.mailService.removeAllReceivedMessages();
        this.addCommentOnIssue();
        ((ServicesControl)this.backdoor.services().anonymous()).runService(10000L);
        this.assertAddedCommentNotifications();
    }

    @Test
    public void testDeletingACommentSendsEmail() throws Exception {
        this.deleteCommentOnIssue();
        this.assertEmailWasSentTo(ADMIN_EMAIL, "deleted a comment", "on", ISSUE_KEY, "some comment", "Add Comment", "Bug", "This message was sent by Atlassian Jira");
    }

    @Test
    public void testDeletingACommentSendsEmailWithFFDisabled() throws Exception {
        this.backdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
        this.deleteCommentOnIssue();
        this.assertEmailWasSentTo(ADMIN_EMAIL, "updated", "an issue", ISSUE_KEY, "some comment", "Change By:", "Add Comment", "Bug", "This message was sent by Atlassian Jira");
    }

    private void assertAddedCommentNotifications() throws InterruptedException, MessagingException, IOException {
        boolean receivedAllMail = this.mailService.waitForIncomingMessage(5000L, 3);
        Assert.assertTrue((String)"Emails are sent", (boolean)receivedAllMail);
        List<MimeMessage> messagesForAssignee = this.getMessagesForRecipient(TED_EMAIL);
        Assert.assertEquals((long)1L, (long)messagesForAssignee.size());
        this.assertEmailBodyContains(messagesForAssignee.get(0), FRED_FULLNAME);
        List<MimeMessage> messagesForMentioned = this.getMessagesForRecipient(FRED_EMAIL);
        Assert.assertEquals((long)1L, (long)messagesForMentioned.size());
        this.assertEmailBodyContains(messagesForMentioned.get(0), FRED_FULLNAME);
    }

    private void addCommentOnIssue() {
        this.navigation.issue().addComment(ISSUE_KEY, "[~admin] [~fred]");
    }

    private void deleteCommentOnIssue() {
        this.tester.beginAt("/browse/TEST-1?page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
        this.tester.clickLink("delete_comment_10000");
        this.tester.submit("Delete");
    }

    private void assertEmailWasSentTo(String emailAddress, String ... expectedTexts) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        Assert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
        for (String expectedText : expectedTexts) {
            this.assertEmailBodyContains(messagesForRecipient.get(0), expectedText);
        }
    }
}

