/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
@LoginAs(user="admin")
public class TestEditComment
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String COMMENT_ID_ADMIN = "10031";
    private static final String COMMENT_ID_FRED = "10040";
    private static final String COMMENT_ID_ANON = "10041";
    private static final String OLD_COMMENT_ANON = "Just a random comment by noname.";
    private static final String OLD_COMMENT_ADMIN = "I&#39;m a hero!";
    private static final String OLD_COMMENT_FRED = "Australia is an island continent.";
    private static final String NEW_COMMENT_ANON = "Firefox rocks!";
    private static final String NEW_COMMENT_ADMIN = "Thunderbird is cool!";
    private static final String NEW_COMMENT_FRED = "Linux just works!";
    private static final String SAVE_BUTTON_NAME = "Save";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestEditComment.xml");
    }

    @Test
    public void testSimpleCommentEdit() {
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.setFormElement("comment", "new func test value");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("Edit comment issue summary for our test");
        this.tester.assertTextPresent("new func test value");
    }

    @Test
    public void testSimpleErrorNoBodyProvided() {
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.setFormElement("comment", "");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertFormElementPresent("comment");
        this.tester.assertTextPresent("Comment body can not be empty!");
        this.tester.assertFormElementPresent(SAVE_BUTTON_NAME);
    }

    @Test
    public void testCommentEditPermissionGroup() throws SAXException {
        String COMMENT1 = "This comment is updated";
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.setFormElement("comment", "This comment is updated");
        this.tester.selectOption("commentLevel", "jira-developers");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("Edit comment issue summary for our test");
        this.tester.assertTextPresent("This comment is updated");
        this.tester.assertTextPresent("Restricted to <span class=redText>jira-developers</span>");
        this.tester.clickLink("edit_comment_10031");
        this.tester.assertOptionEquals("commentLevel", "jira-developers");
    }

    @Test
    public void testCommentEditPermissionRole() throws SAXException {
        String COMMENT1 = "This comment is updated";
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.setFormElement("comment", "This comment is updated");
        this.tester.selectOption("commentLevel", "Developers");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("Edit comment issue summary for our test");
        this.tester.assertTextPresent("This comment is updated");
        this.tester.assertTextPresent("Restricted to <span class=redText>Developers</span>");
        this.tester.clickLink("edit_comment_10031");
        this.tester.assertOptionEquals("commentLevel", "Developers");
    }

    @Test
    public void testCommentEditRemovePermission() throws SAXException {
        String COMMENT1 = "This comment is updated";
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.setFormElement("comment", "This comment is updated");
        this.tester.selectOption("commentLevel", "All Users");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("Edit comment issue summary for our test");
        this.tester.assertTextPresent("This comment is updated");
        this.tester.assertTextNotPresent("Restricted to <span class=redText>Administrators</span>");
    }

    @Test
    public void testCommentEditCommentNotEditedBefore() throws SAXException {
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.assertTextNotPresent("Edited by");
        this.tester.assertTextNotPresent("Edited on");
    }

    @Test
    public void testCommentEditCommentIsSearchable() throws SAXException {
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        String STRANGE_COMMENT = "STRANGE COMMENT";
        this.tester.setFormElement("comment", "STRANGE COMMENT");
        this.tester.selectOption("commentLevel", "All Users");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.navigation.issueNavigator().createSearch("comment ~ \"STRANGE COMMENT\"");
        this.tester.assertTextPresent("Edit comment issue summary for our test");
    }

    @Test
    public void testAnonymousCanCreateComment() {
        this.addCreateCommentPermissionToAnonymous();
        this.navigation.logout();
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        String newComment = "Can I add a comment?";
        this.tester.setFormElement("comment", "Can I add a comment?");
        this.tester.submit();
        this.tester.assertTextPresent("Can I add a comment?");
    }

    @Test
    public void testAnonymousCanSeeAllComments() {
        this.navigation.logout();
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.assertTextPresent(OLD_COMMENT_ANON);
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.assertTextPresent(OLD_COMMENT_FRED);
    }

    @Test
    public void testNoEditPermissions() {
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeAnonymousEditAllCommentsPermission();
        this.removeEditOwnCommentsPermission("jira-users");
        this.removeAnonymousEditOwnCommentsPermission();
        this.assertAdminCanEditAnonymousComment(false);
        this.assertAdminCanEditAdminsComment(false);
        this.assertAdminCanEditFredsComment(false);
        this.navigation.logout();
        this.assertAnonymousCanEditAnonymousComment(false);
        this.assertAnonymousCanEditAdminsComment(false);
        this.assertAnonymousCanEditFredsComment(false);
    }

    @Test
    public void testEditOwnPermissions() {
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeAnonymousEditAllCommentsPermission();
        this.removeEditOwnCommentsPermission("jira-users");
        this.assertAdminCanEditAnonymousComment(false);
        this.assertAdminCanEditAdminsComment(true);
        this.assertAdminCanEditFredsComment(false);
        this.navigation.logout();
        this.assertAnonymousCanEditAnonymousComment(false);
        this.assertAnonymousCanEditAdminsComment(false);
        this.assertAnonymousCanEditFredsComment(false);
    }

    @Test
    public void testEditAllPermissions() {
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeEditOwnCommentsPermission("jira-users");
        this.removeAnonymousEditOwnCommentsPermission();
        this.assertAdminCanEditAnonymousComment(true);
        this.assertAdminCanEditAdminsComment(true);
        this.assertAdminCanEditFredsComment(true);
        this.navigation.logout();
        this.assertAnonymousCanEditAnonymousComment(true);
        this.assertAnonymousCanEditAdminsComment(true);
        this.assertAnonymousCanEditFredsComment(true);
    }

    @Test
    public void testErrorCases() {
        this.tester.gotoPage("/secure/EditComment!default.jspa?id=123&commentId=10041");
        this.tester.assertTextPresent("The issue no longer exists.");
        this.tester.assertFormElementNotPresent(SAVE_BUTTON_NAME);
        String INVALID_COMMENT_ID = "123";
        this.tester.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=123");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Error", "You do not have the permission for this comment."});
        this.removeEditAllCommentsPermission("jira-administrators");
        this.removeAnonymousEditAllCommentsPermission();
        this.removeEditOwnCommentsPermission("jira-users");
        this.removeAnonymousEditOwnCommentsPermission();
        this.tester.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=10041");
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
    }

    @Test
    public void testEditCommentWithTooLongBody() {
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(10L);
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        this.tester.setFormElement("comment", "too long comment");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("The entered text is too long. It exceeds the allowed limit of 10 characters.");
    }

    @Test
    public void testEditCommentWithTextLengthLimitOn() {
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(10L);
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.tester.clickLink("edit_comment_10031");
        this.tester.setWorkingForm("comment-edit");
        this.tester.assertTextPresent(OLD_COMMENT_ADMIN);
        String correctComment = "AllGood";
        this.tester.setFormElement("comment", "AllGood");
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("Edit comment issue summary for our test");
        this.tester.assertTextPresent("AllGood");
        this.assertions.comments(Collections.singletonList("AllGood")).areVisibleTo("admin", ISSUE_KEY);
    }

    private void assertAdminCanEditAnonymousComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ANON, NEW_COMMENT_ANON, true);
    }

    private void assertAdminCanEditAdminsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ADMIN, NEW_COMMENT_ADMIN, true);
    }

    private void assertAdminCanEditFredsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_FRED, NEW_COMMENT_FRED, true);
    }

    private void assertAnonymousCanEditAnonymousComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ANON, NEW_COMMENT_ANON, false);
    }

    private void assertAnonymousCanEditAdminsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_ADMIN, NEW_COMMENT_ADMIN, false);
    }

    private void assertAnonymousCanEditFredsComment(boolean expected) {
        this.verifyUserCanEditComment(expected, COMMENT_ID_FRED, NEW_COMMENT_FRED, false);
    }

    private void verifyUserCanEditComment(boolean expected, String commentId, String commentBody, boolean userExists) {
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        if (expected) {
            this.verifyEditLinkExistsAndEdit(commentId, commentBody, userExists);
        } else {
            this.verifyEditLinkDoesNotExist(commentId);
            this.verifyEditCommentPagePrintsError(commentId);
            this.verifyCommentUpdatePrintsError(commentId);
        }
    }

    private void verifyEditLinkExistsAndEdit(String commentId, String newComment, boolean userExists) {
        String commentLink = "edit_comment_" + commentId;
        this.tester.assertLinkPresent(commentLink);
        this.tester.clickLink(commentLink);
        this.tester.setWorkingForm("comment-edit");
        this.tester.setFormElement("comment", newComment);
        if (userExists) {
            this.tester.selectOption("commentLevel", "All Users");
        }
        this.tester.submit(SAVE_BUTTON_NAME);
        this.tester.assertTextPresent("Edit comment issue summary for our test");
        this.tester.assertTextPresent(newComment);
    }

    private void verifyEditLinkDoesNotExist(String commentId) {
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        String commentLink = "edit_comment_" + commentId;
        this.tester.assertLinkNotPresent(commentLink);
    }

    private void verifyEditCommentPagePrintsError(String commentId) {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/EditComment!default.jspa?id=10000&commentId=" + commentId));
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
    }

    private void verifyCommentUpdatePrintsError(String commentId) {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/EditComment.jspa?id=10000&commentId=" + commentId + "&comment=WooHoo"));
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
    }

    private void removeEditOwnCommentsPermission(String group) {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.EDIT_OWN_COMMENTS, group);
    }

    private void removeAnonymousEditOwnCommentsPermission() {
        this.backdoor.permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_COMMENTS);
    }

    private void removeEditAllCommentsPermission(String group) {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.EDIT_ALL_COMMENTS, group);
    }

    private void removeAnonymousEditAllCommentsPermission() {
        this.backdoor.permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_COMMENTS);
    }

    private void addCreateCommentPermissionToAnonymous() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.ADD_COMMENTS);
    }
}

