/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.SECURITY})
@LoginAs(user="admin")
public class TestConcurrentAttributeUpdates
extends BaseJiraFuncTest {
    public static final String REST_AUTH_RESOURCE = "/rest/auth/latest/session";
    @Inject
    private FuncTestRestClient restClient;
    @Inject
    private FuncTestLogger logger;
    private JSONObject fredGoodCredentials;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        try {
            this.fredGoodCredentials = new JSONObject();
            this.fredGoodCredentials.put("username", "fred");
            this.fredGoodCredentials.put("password", "fred");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testConcurrentLogin() throws Exception {
        this.navigation.login("fred", "fred");
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    WebResponse response = null;
                    try {
                        response = TestConcurrentAttributeUpdates.this.loginAs(TestConcurrentAttributeUpdates.this.fredGoodCredentials);
                        TestConcurrentAttributeUpdates.this.logger.log((Object)"Logging on concurrently");
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                    catch (SAXException e) {
                        Assert.fail((String)e.getMessage());
                    }
                    Assert.assertEquals((long)200L, (long)response.getResponseCode());
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        List<Map<String, Object>> rows = this.backdoor.entityEngine().findByAnd("UserAttribute", EasyMap.build((Object)"userId", (Object)10010L, (Object)"name", (Object)"login.count"));
        Assert.assertEquals((long)1L, (long)rows.size());
    }

    protected WebResponse loginAs(JSONObject json) throws IOException, SAXException {
        return this.restClient.POST(REST_AUTH_RESOURCE, json);
    }
}

