/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@Restore(value="TestCrowdServerConfiguration.xml")
@LoginAs(user="admin")
public class TestCrowdServerConfiguration
extends BaseJiraFuncTest {
    private static final String MY_APP = "My App";
    private static final String MY_APP_ADDRESS = "192.168.0.1";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void goToCrowdServerConfiguration() {
        this.navigation.gotoPage("secure/project/ConfigureCrowdServer.jspa");
    }

    @Test
    public void testAddApplication() throws Exception {
        this.tester.clickLink("crowd-add-application");
        String appName = "FishEye";
        String appAddress = "127.0.0.1";
        this.submitEditForm("", "", "not_an_address");
        this.textAssertions.assertTextPresent(this.locator.css("#edit-crowd-application-name-error"), "You must provide an application name.");
        this.textAssertions.assertTextPresent(this.locator.css("#edit-crowd-application-credential-error"), "A password is required.");
        this.textAssertions.assertTextPresent(this.locator.css("#edit-crowd-application-remoteAddresses-error"), "'not_an_address' is not a valid IP address.");
        this.submitEditForm("FishEye", "pass", "127.0.0.1");
        this.assertAppPresent("FishEye", "127.0.0.1");
    }

    @Test
    public void testEditApplication() throws Exception {
        String newAppName = "MyNewApp";
        String newAppAddress = "127.0.0.127";
        this.tester.clickLink("crowd-edit-application-My App");
        this.submitEditForm("", "", "not_an_address");
        this.textAssertions.assertTextPresent(this.locator.css("#edit-crowd-application-name-error"), "You must provide an application name.");
        this.textAssertions.assertTextNotPresent(this.locator.css("#edit-crowd-application-credential-error"), "A password is required.");
        this.textAssertions.assertTextPresent(this.locator.css("#edit-crowd-application-remoteAddresses-error"), "'not_an_address' is not a valid IP address.");
        this.submitEditForm("MyNewApp", "", "127.0.0.127");
        this.assertAppPresent("MyNewApp", "127.0.0.127");
        this.assertAppNotPresent(MY_APP, MY_APP_ADDRESS);
    }

    @Test
    public void testDeleteApplication() throws Exception {
        this.tester.clickLink("crowd-delete-application-My App");
        this.assertAppNotPresent(MY_APP, MY_APP_ADDRESS);
    }

    private void submitEditForm(String name, String credential, String remoteAddresses) {
        this.tester.setWorkingForm("edit-crowd-application");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("credential", credential);
        this.tester.setFormElement("remoteAddresses", remoteAddresses);
        this.tester.clickButton("edit-crowd-application-submit");
    }

    private void assertAppPresent(String appName, String appAddress) {
        String appRowLocator = String.format("#crowd-app-%s", appName);
        this.textAssertions.assertTextPresent(this.locator.css(appRowLocator + " td[headers=application]"), appName);
        this.textAssertions.assertTextPresent(this.locator.css(appRowLocator + " td[headers=address]"), appAddress);
    }

    private void assertAppNotPresent(String appName, String appAddress) {
        String appRowLocator = String.format("#crowd-app-%s", appName);
        this.textAssertions.assertTextNotPresent(this.locator.css(appRowLocator + " td[headers=application]"), appName);
        this.textAssertions.assertTextNotPresent(this.locator.css(appRowLocator + " td[headers=address]"), appAddress);
    }
}

