/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
@LoginAs(user="admin")
public class TestCascadingSelectCustomField
extends BaseJiraFuncTest {
    private static final String CUSTOMFIELD_10000 = "customfield_10000";
    private static final String CUSTOMFIELD_10000_OPTION = "customfield_10000:1";
    private static final String CUSTOMFIELD_10000_1 = "customfield_10000:1";
    private static final String CASCADING_SELECT_NAME = "asdf";
    private static final String UPDATE_FIELD_TEXT = "Update the fields of the issue to relate to the new project.";
    private static final String ERROR_PRESENT_FOR_BAD_OPTION = "The option 'a1' is invalid for parent option 'test'";
    private static final String HOMO_PID_OPTION = "10001_1_pid";
    private static final String MONKEY_PID_OPTION = "10000_1_pid";
    private static final String MOVE_ISSUES_CONFIRMATION_TEXT = "Confirmation";
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("move-issue");
        this.tester.setFormElement("pid", "10001");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent(UPDATE_FIELD_TEXT);
        this.tester.assertTextPresent(CASCADING_SELECT_NAME);
        this.tester.selectOption(CUSTOMFIELD_10000, "test");
        this.tester.selectOption("customfield_10000:1", "t1");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("stuff");
        this.tester.assertTextPresent("s1");
        this.tester.assertTextPresent("test");
        this.tester.assertTextPresent("t1");
        this.tester.submit("Move");
        this.tester.assertTextPresent("test");
        this.tester.assertTextPresent("t1");
    }

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testMoveIssueWithCascadingSelectCustomFieldWithBadValues() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("move-issue");
        this.tester.setFormElement("pid", "10001");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent(UPDATE_FIELD_TEXT);
        this.tester.assertTextPresent(CASCADING_SELECT_NAME);
        this.tester.selectOption(CUSTOMFIELD_10000, "test");
        this.tester.selectOption("customfield_10000:1", "a1");
        this.tester.submit("Next >>");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded(ERROR_PRESENT_FOR_BAD_OPTION);
    }

    @Test
    @Restore(value="TestBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.navigation.issue().selectProject("monkey", MONKEY_PID_OPTION);
        this.navigation.issue().selectProject("homosapien", HOMO_PID_OPTION);
        this.tester.submit("Next");
        this.tester.selectOption(CUSTOMFIELD_10000, "test");
        this.tester.selectOption("customfield_10000:1", "t1");
        this.tester.submit("Next");
        this.tester.selectOption(CUSTOMFIELD_10000, "stuff");
        this.tester.selectOption("customfield_10000:1", "s1");
        this.tester.submit("Next");
        this.tester.assertTextPresent(MOVE_ISSUES_CONFIRMATION_TEXT);
    }

    @Test
    @Restore(value="TestBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testEditIssueWithCascadingSelectField() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption(CUSTOMFIELD_10000, "cranky");
        this.tester.selectOption("customfield_10000:1", "p1");
        this.tester.submit("Update");
        this.tester.assertTextPresent(CASCADING_SELECT_NAME);
        this.tester.assertTextPresent("cranky");
        this.tester.assertTextPresent("p1");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption(CUSTOMFIELD_10000, "stuff");
        this.tester.selectOption("customfield_10000:1", "p1");
        this.tester.submit("Update");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("The option 'p1' is invalid for parent option 'stuff'");
    }

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testCreateIssueWithCascadingSelect() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "Test summary");
        this.tester.selectOption(CUSTOMFIELD_10000, "cranky");
        this.tester.selectOption("customfield_10000:1", "s1");
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("The option 's1' is invalid for parent option 'cranky'");
        this.tester.selectOption(CUSTOMFIELD_10000, "stuff");
        this.tester.selectOption("customfield_10000:1", "s1");
        this.tester.submit("Create");
        this.tester.assertTextPresent(CASCADING_SELECT_NAME);
        this.tester.assertTextPresent("stuff");
        this.tester.assertTextPresent("s1");
    }

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testCreateIssueWithCascadingSelectChoosingOptionsNoneForParent() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "Test summary");
        this.tester.selectOption(CUSTOMFIELD_10000, "None");
        this.tester.submit("Create");
        this.tester.assertTextNotPresent("asdf:");
    }

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testCreateIssueWithCascadingSelectChoosingOptionsNoneForChild() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "Test summary");
        this.tester.selectOption(CUSTOMFIELD_10000, "stuff");
        this.tester.selectOption("customfield_10000:1", "None");
        this.tester.submit("Create");
        this.tester.assertTextPresent("stuff");
    }

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testSetDefaultNoneOptionsForCascadingSelect() {
        this.navigation.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + CustomFields.numericCfId(CUSTOMFIELD_10000));
        this.tester.clickLinkWithText("Edit Default Value");
        this.tester.selectOption(CUSTOMFIELD_10000, "None");
        this.tester.submit();
    }

    @Test
    @Restore(value="TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml")
    public void testIssueNavigatorSearchCascadingSelectWithAllOption() {
        this.navigation.issueNavigator().createSearch("project=homosapien");
        this.tester.assertTextPresent("This is a test bug for the subversion plugin");
    }

    @Test
    @Restore(value="TestDeleteOptionFromCascadingSelectCustomField.xml")
    public void testDeleteOptionFromFieldAtFirstLevelOnTheIssue() {
        this.removeOptions("10000", "10000", "HSP-1");
        this.tester.assertTextPresent("Edit Options for Custom Field");
        this.tester.assertTextNotPresent("Option_A");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertions.assertNodeByIdDoesNotExist("rowForcustomfield_10000");
    }

    @Test
    @Restore(value="TestDeleteOptionFromCascadingSelectCustomField.xml")
    public void testDeleteOptionFromFieldAtSecondLevelOnTheIssue() {
        this.removeSubOptions(10000L, "Option_B", "10003", "HSP-3");
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//*[@class='instructions']"), "with parent option Option_B");
        this.tester.assertTextPresent("There are currently no options available for this select list");
        this.navigation.issue().viewIssue("HSP-3");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10000-val"), "Option_B");
    }

    @Test
    @Restore(value="TestDeleteOptionFromCascadingSelectCustomField.xml")
    public void testDeleteOptionFromFieldAtFirstLevelWithSubOptions() {
        this.removeOptions("10000", "10001", "HSP-3");
        this.tester.assertTextPresent("Edit Options for Custom Field");
        this.tester.assertTextNotPresent("Option_B");
        this.navigation.issue().viewIssue("HSP-3");
        this.assertions.assertNodeByIdDoesNotExist("rowForcustomfield_10000");
    }

    @Test
    @Restore(value="TestDeleteOptionFromCascadingSelectCustomField.xml")
    public void testDeleteOptionFromFieldWithNoAssociatedIssues() {
        this.removeOptions("10000", "10002", null);
        this.tester.assertTextPresent("Edit Options for Custom Field");
        this.tester.assertTextNotPresent("Option_C");
    }

    private void removeOptions(String numericCustomFieldId, String options, String issueAffected) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLink("del_" + options);
        this.assertRemoveOptionConfirmationScreen(issueAffected);
        this.tester.submit("Delete");
    }

    private void removeSubOptions(Long customFieldId, String parentOption, String optionToRemove, String issueAffected) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + customFieldId);
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLinkWithText(parentOption);
        this.tester.clickLink("del_" + optionToRemove);
        this.assertRemoveOptionConfirmationScreen(issueAffected);
        this.tester.submit("Delete");
    }

    private void assertRemoveOptionConfirmationScreen(String issueAffected) {
        String issueCount = issueAffected == null ? "0" : "1";
        ArrayList<String> textSequence = new ArrayList<String>();
        textSequence.add("Issues with this value");
        textSequence.add(issueCount);
        if (issueAffected != null) {
            textSequence.add(issueAffected);
        }
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), textSequence.toArray(new String[textSequence.size()]));
    }
}

