/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterUtils;
import com.atlassian.jira.util.json.JSONException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
public class TestCustomFieldMultiUserPicker
extends BaseJiraFuncTest {
    private static final FeatureFlag CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE = FeatureFlag.featureFlag((String)"jira.customfields.configure.modern.ui");
    private static final String FIELD_NAME = "Developer";
    private static final String DEFAULT_CONTEXT_NAME = "Default context for Developer";
    private static final String[] ALL_GROUPS = new String[]{"jira-users", "jira-developers", "jira-administrators"};
    private static final long[] ALL_ROLE_IDS = new long[]{10000L, 10001L, 10002L};
    private static final Map<Long, String> ALL_ROLE_ID_TO_NAME_MAP = ImmutableMap.of((Object)10002L, (Object)"Administrators", (Object)10001L, (Object)"Developers", (Object)10000L, (Object)"Users");
    private static final String EDIT_DEFAULT_VALUE_LINK = "customfield_10000-edit-default";
    private static final String SET_DEFAULT_BUTTON_NAME = "Set Default";
    private static final String CUSTOMFIELD_ID = "customfield_10000";
    private static final String CANCEL_BUTTON_NAME = "cancelButton";
    private static final String CREATE_BUTTON_NAME = "Create";
    private static final String NO_COMMENTS_MESSAGE = "There are no comments yet on this issue.";
    private static final String UPDATE_BUTTON_NAME = "Update";
    private static final String NEXT_BUTTON_NAME = "nextBtn";
    private static final String NUMERIC_CUSTOMFIELD_ID = "10000";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.backdoor.darkFeatures().disableForSite(CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE);
        this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.backdoor.darkFeatures().enableForSite(CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE);
    }

    @Test
    public void testCreateAndSetDefaultValue() {
        this.createMultiUserPickerAndGoToConfigurationPage();
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.assertTextNotPresent("fred");
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.assertFormElementEquals(CUSTOMFIELD_ID, "");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.assertTextPresent("Fred Normal");
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.assertFormElementEquals(CUSTOMFIELD_ID, "fred");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred, admin");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.textAssertions.assertTextPresent(this.locator.css(".jiraformbody .formtitle"), DEFAULT_CONTEXT_NAME);
        this.textAssertions.assertTextSequence(this.locator.id("customfield_10000-field"), "Administrator", "Fred Normal");
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.assertFormElementEquals(CUSTOMFIELD_ID, "admin, fred");
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.assertFormElementEquals(CUSTOMFIELD_ID, "admin");
        this.tester.setFormElement(CUSTOMFIELD_ID, "");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.assertFormElementEquals(CUSTOMFIELD_ID, "");
    }

    @Test
    public void testUserFilterSelection() throws JSONException {
        this.createMultiUserPickerAndGoToConfigurationPage();
        this.assertUserFilterSummary(UserFilter.DISABLED);
        UserFilter[] testData = new UserFilter[]{UserFilter.DISABLED, this.filter(this.roles(new Long[0]), this.groups("jira-developers")), this.filter(this.roles(new Long[0]), this.groups("jira-developers", "jira-administrators")), this.filter(this.roles(new Long[0]), this.groups("jira-developers", "jira-administrators", "jira-users")), this.filter(this.roles(10002L), this.groups("jira-developers", "jira-administrators", "jira-users")), this.filter(this.roles(10002L, 10001L), this.groups("jira-developers", "jira-administrators", "jira-users")), this.filter(this.roles(10002L, 10001L, 10000L), this.groups("jira-developers", "jira-administrators", "jira-users")), this.filter(this.roles(10002L, 10001L, 10000L), this.groups("jira-developers", "jira-administrators")), this.filter(this.roles(10002L, 10001L, 10000L), this.groups("jira-developers")), this.filter(this.roles(10002L, 10001L, 10000L), this.groups(new String[0])), this.filter(this.roles(10002L, 10001L), this.groups(new String[0])), this.filter(this.roles(10002L), this.groups(new String[0])), this.filter(this.roles(new Long[0]), this.groups(new String[0]))};
        UserFilter originalUserFilter = UserFilter.DISABLED;
        for (UserFilter newUserFilter : testData) {
            this.setFilterAndAssert(originalUserFilter, newUserFilter);
            originalUserFilter = newUserFilter;
        }
    }

    @Test
    public void testSetDefaultValueWithUserFilter() throws JSONException {
        this.createMultiUserPickerAndGoToConfigurationPage();
        this.setUserFilter(this.filter(this.roles(new Long[0]), this.groups("jira-administrators")));
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.clickLink(CANCEL_BUTTON_NAME);
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.setUserFilter(this.filter(this.roles(new Long[0]), this.groups("jira-administrators", "jira-developers")));
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.clickLink(CANCEL_BUTTON_NAME);
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.setUserFilter(this.filter(this.roles(new Long[0]), this.groups("jira-administrators", "jira-developers", "jira-users")));
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.setUserFilter(this.filter(this.roles(new Long[0]), this.groups("jira-users")));
        this.tester.clickLink(EDIT_DEFAULT_VALUE_LINK);
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(SET_DEFAULT_BUTTON_NAME);
        this.tester.assertTextPresent("Fred Normal");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
    }

    @Test
    public void testSetValueWithUserFilterByGroups() throws JSONException {
        this.createMultiUserPickerAndGoToConfigurationPage();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.setUserFilter(this.filter(this.roles(new Long[0]), this.groups("jira-developers")));
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent(NO_COMMENTS_MESSAGE);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.navigation.issue().gotoEditIssue("HSP-1");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent(NO_COMMENTS_MESSAGE);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.setUserFilter(this.filter(this.roles(new Long[0]), this.groups("jira-users")));
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
    }

    @Test
    public void testSetValueWithUserFilterByProjectRoles() throws JSONException {
        this.administration.roles().addProjectRoleForUser("homosapien", "Administrators", "admin");
        this.administration.roles().addProjectRoleForUser("homosapien", "Users", "fred");
        this.createMultiUserPickerAndGoToConfigurationPage();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.setUserFilter(this.filter(this.roles(10002L), this.groups(new String[0])));
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent(NO_COMMENTS_MESSAGE);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.navigation.issue().gotoEditIssue("HSP-1");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent(NO_COMMENTS_MESSAGE);
        this.tester.setFormElement(CUSTOMFIELD_ID, "admin");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
        this.setUserFilter(this.filter(this.roles(10000L), this.groups(new String[0])));
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement(CUSTOMFIELD_ID, "fred");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent(NO_COMMENTS_MESSAGE);
    }

    private void createMultiUserPickerAndGoToConfigurationPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.tester.submit(NEXT_BUTTON_NAME);
        this.tester.setFormElement("fieldName", FIELD_NAME);
        this.tester.submit(NEXT_BUTTON_NAME);
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.administration.customFields().goToCustomFieldConfiguration(NUMERIC_CUSTOMFIELD_ID);
    }

    private UserFilter filter(Collection<Long> roleIds, Collection<String> groups) {
        return new UserFilter(true, roleIds, groups);
    }

    private Collection<Long> roles(Long ... roleIds) {
        return ImmutableList.copyOf((Object[])roleIds);
    }

    private Collection<String> groups(String ... groups) {
        return ImmutableList.copyOf((Object[])groups);
    }

    private void setFilterAndAssert(UserFilter originalUserFilter, UserFilter newUserFilter) throws JSONException {
        this.tester.clickLink("customfield_10000-edit-userpickerfilter");
        this.tester.assertTextPresent("User filtering for Custom Field : Developer");
        this.tester.setFormElement("userFilterJson", UserFilterUtils.toJson((UserFilter)newUserFilter, null).toString());
        this.tester.submit("Save");
        this.tester.assertTextPresent(DEFAULT_CONTEXT_NAME);
        this.assertUserFilterSummary(newUserFilter);
    }

    private void setUserFilter(UserFilter userFilter) throws JSONException {
        this.administration.customFields().goToCustomFieldConfiguration(NUMERIC_CUSTOMFIELD_ID);
        this.setFilterAndAssert(null, userFilter);
    }

    private void assertUserFilterSummary(UserFilter userFilter) {
        if (!userFilter.isEnabled()) {
            this.tester.assertTextPresent("All active users are allowed");
            this.tester.assertTextNotPresent("Filtering users by the following");
        } else if (CollectionUtils.isNotEmpty((Collection)userFilter.getGroups()) || CollectionUtils.isNotEmpty((Collection)userFilter.getRoleIds())) {
            this.tester.assertTextPresent("Filtering users by the following");
            for (Long roleId : userFilter.getRoleIds()) {
                this.tester.assertTextPresent("<b>Project Role</b>: " + ALL_ROLE_ID_TO_NAME_MAP.get(roleId));
            }
            String[] stringArray = (String[])ALL_ROLE_IDS;
            int roleId = stringArray.length;
            for (int i = 0; i < roleId; ++i) {
                Long roleId2 = (long)stringArray[i];
                if (userFilter.getRoleIds().contains(roleId2)) continue;
                this.tester.assertTextNotPresent("<b>Project Role</b>: " + ALL_ROLE_ID_TO_NAME_MAP.get(roleId2));
            }
            for (String groupName : userFilter.getGroups()) {
                this.tester.assertTextPresent("<b>Group</b>: " + groupName);
            }
            for (String groupName : ALL_GROUPS) {
                if (userFilter.getGroups().contains(groupName)) continue;
                this.tester.assertTextNotPresent("<b>Group</b>: " + groupName);
            }
        } else {
            this.tester.assertTextPresent("No users are allowed");
            this.tester.assertTextNotPresent("Filtering users by the following");
        }
    }
}

