/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCustomFieldXss
extends BaseJiraFuncTest {
    private static final String RAW_DESC_TEMPLATE = "description *wiki* markup <div>%s</div>";
    private static final String HTML_DESC_TEMPLATE = "description *wiki* markup <div>%s</div>";
    private static final String WIKI_DESC_TEMPLATE = "<p>description <b>wiki</b> markup &lt;div&gt;%s&lt;/div&gt;</p>";
    private static final String CUSTOM_FIELD_TITLE = "<div>xsstest</div>";
    private static final String CUSTOM_FIELD_WIKI = "&lt;div&gt;xsstest&lt;/div&gt;";
    private static final String CUSTOM_DESCRIPTION_HTML = "<div>xssdescription</div>";
    private static final Map<String, List<String>> SEARCHERS = ImmutableMap.builder().put((Object)CustomFields.builtInCustomFieldKey("textsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("textfield")).put((Object)CustomFields.builtInCustomFieldKey("exacttextsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("url")).put((Object)CustomFields.builtInCustomFieldKey("daterange"), TestCustomFieldXss.toBuiltInCustomFieldKeys("datepicker")).put((Object)CustomFields.builtInCustomFieldKey("exactnumber"), TestCustomFieldXss.toBuiltInCustomFieldKeys("float")).put((Object)CustomFields.builtInCustomFieldKey("numberrange"), TestCustomFieldXss.toBuiltInCustomFieldKeys("float")).put((Object)CustomFields.builtInCustomFieldKey("projectsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("project")).put((Object)CustomFields.builtInCustomFieldKey("grouppickersearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("multigrouppicker")).put((Object)CustomFields.builtInCustomFieldKey("multiselectsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("select", "radiobuttons", "multicheckboxes")).put((Object)CustomFields.builtInCustomFieldKey("cascadingselectsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("cascadingselect")).put((Object)CustomFields.builtInCustomFieldKey("labelsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("labels")).build();
    private static final ImmutableMap<String, String> SEARCHERS_NON_RENDERING = ImmutableMap.of((Object)CustomFields.builtInCustomFieldKey("versionsearcher"), (Object)CustomFields.builtInCustomFieldKey("version"), (Object)CustomFields.builtInCustomFieldKey("userpickergroupsearcher"), (Object)CustomFields.builtInCustomFieldKey("userpicker"));
    @Inject
    private Administration administration;

    private static List<String> toBuiltInCustomFieldKeys(String ... keys) {
        ArrayList customFieldKeys = Lists.newArrayListWithCapacity((int)keys.length);
        for (String key : keys) {
            customFieldKeys.add(CustomFields.builtInCustomFieldKey(key));
        }
        return customFieldKeys;
    }

    private static String fieldDescription(String fieldId) {
        return String.format("description *wiki* markup <div>%s</div>", fieldId);
    }

    private static String fieldDescriptionHtml(String fieldId) {
        return String.format("description *wiki* markup <div>%s</div>", fieldId);
    }

    private static String fieldDescriptionWikiFormat(String fieldId) {
        return String.format(WIKI_DESC_TEMPLATE, fieldId);
    }

    @Before
    public void setUp() throws Exception {
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", true);
    }

    @Test
    public void testCustomFieldDescriptionsCanBeRenderedAsRawHtmlOrWikiMarkUpInIssueNavigator() throws Exception {
        for (Map.Entry<String, List<String>> entry : SEARCHERS.entrySet()) {
            this.testSingleCustomFieldDescriptionOnIssueNavigatorScreen(entry.getValue(), entry.getKey());
        }
    }

    @Test
    public void testNonRenderingCustomFieldSearchersInIssueNavigator() throws Exception {
        for (Map.Entry entry : SEARCHERS_NON_RENDERING.entrySet()) {
            this.testSingleCustomFieldOnIssueNavigatorScreen((String)entry.getValue(), (String)entry.getKey());
        }
    }

    @Test
    public void testCustomFieldDescriptionsInBulkChangeIssue() throws Exception {
        this.restoreDataForTest();
        this.backdoor.project().addProject("TestProject", "TEST", "admin");
        this.backdoor.issues().createIssue("TEST", "This is just a test");
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", false);
        this.checkBulkIssueTransition(false);
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", true);
        this.checkBulkIssueTransition(true);
    }

    private void testSingleCustomFieldOnIssueNavigatorScreen(String customFieldType, String customFieldSearcher) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", TestCustomFieldXss.fieldDescription(customFieldType), customFieldType, customFieldSearcher);
        this.navigation.issueNavigator().displayAllIssues();
        Assert.assertFalse((String)("Description should be rendered as wiki markup for " + customFieldSearcher), (boolean)this.getPageSource().contains("<div>" + customFieldType + "</div>"));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void testSingleCustomFieldDescriptionOnIssueNavigatorScreen(List<String> customFieldTypes, String customFieldSearcher) {
        for (String customFieldType : customFieldTypes) {
            this.testSingleCustomFieldDescriptionOnIssueNavigatorScreen(customFieldType, customFieldSearcher);
        }
    }

    private void testSingleCustomFieldDescriptionOnIssueNavigatorScreen(String customFieldType, String customFieldSearcher) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", TestCustomFieldXss.fieldDescription(customFieldType), customFieldType, customFieldSearcher);
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", true);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=" + fieldId + "&decorator=none&jqlContext=");
        Assert.assertTrue((String)("HTML in Custom Fields is enabled so the description should be rendered as raw HTML for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldXss.fieldDescriptionHtml(customFieldType)));
        this.backdoor.applicationProperties().setOption("jira.custom.field.html.enabled", false);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=" + fieldId + "&decorator=none&jqlContext=");
        Assert.assertTrue((String)("HTML in Custom Fields is disabled so the description should be rendered as wiki markup for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldXss.fieldDescriptionWikiFormat(customFieldType)));
        Assert.assertFalse((String)("HTML in Custom Fields is disabled so the description should be rendered as wiki markup for " + customFieldSearcher), (boolean)this.getPageSource().contains("<div>" + customFieldType + "</div>"));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void checkBulkIssueTransition(boolean shouldHtmlBeEnabled) {
        this.navigation.issueNavigator().displayAllIssues();
        String closeIssue = "jira_2_6";
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.TRANSITION).chooseWorkflowTransition(new BulkChangeWizard.BulkOperationsCustom("jira_2_6"));
        Assert.assertFalse((String)"Custom field names should not be rendered as html in this page", (boolean)this.getPageSource().contains(CUSTOM_FIELD_TITLE));
        Assert.assertTrue((String)"Custom field names should be rendered as wiki markup in this page", (boolean)this.getPageSource().contains(CUSTOM_FIELD_WIKI));
        Assert.assertThat((String)this.getAssertionMessage(shouldHtmlBeEnabled), (Object)this.getPageSource().contains(CUSTOM_DESCRIPTION_HTML), (Matcher)Matchers.is((Object)shouldHtmlBeEnabled));
    }

    private String getAssertionMessage(boolean shouldHtmlBeEnabled) {
        return "HTML in custom fields is " + shouldHtmlBeEnabled + ": custom field descriptions should " + (shouldHtmlBeEnabled ? "" : "not ") + "be rendered as html";
    }

    private void restoreDataForTest() {
        this.administration.restoreData("TestCustomFieldTitle.xml");
    }

    private String getPageSource() {
        return this.tester.getDialog().getResponseText();
    }
}

