/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.functest.rule.TpmDbRule;
import com.atlassian.jira.issue.fields.FieldId;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.beans.CustomFieldConfig;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.ztests.customfield.ArrowControlledOrdering;
import com.google.common.collect.ImmutableList;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebLink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
@LoginAs(user="admin")
public class TestCustomFields
extends BaseJiraFuncTest {
    private static final FeatureFlag CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE = FeatureFlag.featureFlag((String)"jira.customfields.configure.modern.ui");
    private static final String TEST_CUSTOM_FIELDS_XML_PRJ_HOMOSAP_ID = "10000";
    private static final String TEST_CUSTOM_FIELDS_XML_PRJ_NEO_ID = "10010";
    private static final String TEST_CUSTOM_FIELDS_XML_VERSION_1_DOT_1_ID = "10010";
    private static final String TEST_CUSTOM_FIELDS_XML_VERSION_1_DOT_2_ID = "10011";
    private static final String TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1 = "HSP-1";
    private static final String TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_2 = "HSP-2";
    private static final String TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_3 = "NDT-1";
    private static final String CUSTOM_FIELD_NAME_ONE = "Assigned to Section";
    private static final String CUSTOM_FIELD_NAME_TWO = "Affects Project";
    private static final String CUSTOM_FIELD_NAME_THREE = "Time created";
    private static final String CUSTOM_FIELD_NAME_CASCADING_SELECT = "cascading select field name";
    private static final String CUSTOM_FIELD_NAME_MULTI_CHECKBOX = "multicheckboxes field name";
    private static final String CUSTOM_FIELD_NAME_MULTI_SELECT = "multiselect field name";
    private static final String CUSTOM_FIELD_NAME_PROJECT_PICKER = "project picker field name";
    private static final String CUSTOM_FIELD_NAME_TEXT_FIELD = "text field field name";
    private static final String CUSTOM_FIELD_NAME_DATE_TIME = "date time field name";
    private static final String CUSTOM_FIELD_NAME_USER_PICKER = "user picker field name";
    private static final String CUSTOM_FIELD_NAME_MULTI_USER_PICKER = "multi user picker field name";
    private static final String CUSTOM_FIELD_NAME_DATE_PICKER = "date picker field name";
    private static final String CUSTOM_FIELD_NAME_FREE_TEXT = "free text field name";
    private static final String CUSTOM_FIELD_NAME_NUMBER = "number field name";
    private static final String CUSTOM_FIELD_NAME_RADIO_BUTTONS = "radio buttons field name";
    private static final String CUSTOM_FIELD_NAME_SELECT_LIST = "select list field name";
    private static final String CUSTOM_FIELD_NAME_URL_FIELD = "url field name";
    private static final String CUSTOM_FIELD_NAME_VERSION_PICKER = "version picker field name";
    private static final String FUNCTEST_CUSTOM_FIELD_NAME_TEXTAREA = "functest textarea field name";
    private static final String SYSTEM_FIELD_DESCRIPTION_ID = "description";
    private static final List<String> customFieldNames = ImmutableList.builder().add((Object[])new String[]{"cascading select field name", "multicheckboxes field name", "multiselect field name", "project picker field name", "text field field name", "date time field name", "user picker field name", "date picker field name", "free text field name", "number field name", "radio buttons field name", "select list field name", "url field name", "version picker field name"}).build();
    private static final String freeTextEntry = "This is the default text area value\n with newlines possible\n and stuff.";
    private static final String freeTextEntryLong = StringUtils.repeat((String)"X", (int)10000);
    private static final String numberEntry = "43";
    private static final String textEntry = "Text Field - This is the default text";
    private static final String urlEntry = "http://www.testhis.com";
    private static final String userEntry = "custom_field_user";
    private static final String version_oneDotOne = "1.1";
    private static final String version_oneDotTwo = "1.2";
    private static final String summary = "This is the summary of this issue.";
    private String fieldId_global;
    private String fieldId_issue;
    private String fieldId_project;
    private String cascadingSelectId;
    private String datePickerId;
    private String userPickerId;
    private String versionPickerId;
    private String freeTextId;
    private String multiSelectId;
    private String multiCheckboxId;
    private String projectPickerId;
    private String radioButtonId;
    private String selectListId;
    private String textFieldId;
    private String urlId;
    private String dateTimeId;
    private String numberId;
    @Inject
    private HtmlPage page;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Form form;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.backdoor().darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.administration.backdoor().darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.administration.backdoor().darkFeatures().disableForSite(CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE);
    }

    @After
    public void tearDown() {
        this.administration.backdoor().darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.administration.backdoor().darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.administration.backdoor().darkFeatures().enableForSite(CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE);
    }

    @Test
    @HttpUnitConfiguration(enableScripting=true)
    @RestoreBlankInstance
    public void testReturnUrl() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        this.pressCancel();
        this.tester.assertTitleEquals("Custom fields - jWebTest JIRA installation");
    }

    private void pressCancel() {
        Assert.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.tester.setWorkingForm("jiraform");
        this.tester.clickLink("cancelButton");
    }

    @Ignore(value="FLASH-892 rewrite to WebDriver")
    @Test
    @Restore(value="TestCustomFields.xml")
    public void testCustomFields() {
        this.customFieldsAddField();
        this.customFieldsDeleteField();
        this.customFieldsAddCustomFieldOption();
        this.customFieldsDelCustomFieldOption();
        this.customFieldCreateIssueWithCustomFields();
        this.customFieldCreateIssueWithFieldScope();
        this.customFieldsEditIssueWithCustomFields();
        this.customFieldEditIssueWithFieldScope();
        this.customFieldsMoveIssueWithCustomFieldsforProject();
        this.customFieldWithFieldScreenSchemes();
        this.customFieldsMoveIssueWithCustomFieldsforIssueType();
        this.customFieldCreateSubTaskWithCustomFields();
    }

    @Test
    @Restore(value="TestCustomFields.xml")
    public void testAllCustomFields() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.setupAllCustomFields();
        this.createAndValidateIssue();
        this.viewAndValidateIssue(false);
        this.editAndValidateIssue();
        this.viewAndValidateIssue(true);
        this.viewIssueInNavigator();
    }

    @Test
    @RestoreBlankInstance
    public void testNumberCustomField() {
        this.setupNumberField("");
        String xsrfToken = this.page.getXsrfToken();
        this.tester.gotoPage("/secure/CreateIssueDetails.jspa?pid=10000&issuetype=2&atl_token=" + xsrfToken);
        this.tester.setFormElement("customfield_10000", "\"><script>alert(document.cookie);</script>");
        this.tester.submit("Create");
        this.tester.assertTextPresent("&#39;&quot;&gt;&lt;script&gt;alert(document.cookie);&lt;/script&gt;&#39; is an invalid number");
        Assert.assertEquals((Object)this.form.switchTo("issue-create").getParameterValue("customfield_10000"), (Object)"\"><script>alert(document.cookie);</script>");
    }

    @Test
    @RestoreBlankInstance
    public void testUserCustomFieldWithInvalidDefaultValue() {
        String userPickerId = this.addCustomField("userpicker", CUSTOM_FIELD_NAME_USER_PICKER);
        this.administration.customFields().setDefaultValue(userPickerId, "user_does_not_exist");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("User 'user_does_not_exist' was not found in the system");
    }

    @TpmDbRule.TpmSpecificDb(databases={TpmDbRule.TpmDbType.ORACLE})
    @Test
    @RestoreBlankInstance
    public void testFreeTextCustomFieldWithTooLongDefaultValue() {
        String freeTextId = this.addCustomField("textarea", CUSTOM_FIELD_NAME_FREE_TEXT);
        this.administration.customFields().setDefaultValue(freeTextId, freeTextEntryLong);
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("We can't save your field because: ORA-12899: value too large for column");
    }

    @Test
    @RestoreBlankInstance
    public void testMultiUserCustomFieldWithInvalidDefaultValue() {
        String multiUserPickerId = this.addCustomField("multiuserpicker", CUSTOM_FIELD_NAME_MULTI_USER_PICKER);
        this.administration.customFields().setDefaultValue(multiUserPickerId, "user_does_not_exist");
        this.tester.assertTextPresent("Could not find usernames: user_does_not_exist");
    }

    private void setupAllCustomFields() {
        this.setupCascadingSelect();
        this.setupDateTime("24/Aug/2005 6:00 AM");
        this.setupMultiSelect((Collection<String>)ImmutableList.of((Object)"MultiSelect One", (Object)"MultiSelect Two", (Object)"MultiSelect Three"));
        this.setupProjectPicker(TEST_CUSTOM_FIELDS_XML_PRJ_HOMOSAP_ID);
        this.setupTextField(textEntry);
        this.setupUserPicker(userEntry);
        this.setupDatePicker("23/Aug/2005");
        this.setupFreeText(freeTextEntry);
        this.setupMultiCheckboxes((Collection<String>)ImmutableList.of((Object)"MultiCheckBox One", (Object)"MultiCheckBox Two", (Object)"MultiCheckBox Three"));
        this.setupNumberField(numberEntry);
        this.setupRadioButtons((Collection<String>)ImmutableList.of((Object)"Radio One", (Object)"Radio Two", (Object)"Radio Three"));
        this.setupSelectList((Collection<String>)ImmutableList.of((Object)"Select List One", (Object)"Select List Two", (Object)"Select List Three"));
        this.setupURLField(urlEntry);
        this.setupVersionPicker("10010");
    }

    private void viewIssueInNavigator() {
        Map customFields = this.backdoor.customFields().getCustomFields().stream().collect(Collectors.toMap(CustomFieldResponse::getName, Function.identity()));
        this.backdoor.columnControl().addLoggedInUserColumns((List)customFieldNames.stream().map(customFields::get).map(customFieldResponse -> customFieldResponse.id).collect(CollectorsUtil.toImmutableListWithSizeOf(customFieldNames)));
        this.navigation.issueNavigator().createSearch("project = 10000");
        this.viewAndValidateIssue(true);
        this.backdoor.columnControl().restoreLoggedInUserColumns();
    }

    private void createAndValidateIssue() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.validateAndSetCustomFieldValues(false);
    }

    private void validateAndSetCustomFieldValues(boolean edit) {
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_CASCADING_SELECT);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_DATE_PICKER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_DATE_TIME);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_FREE_TEXT);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_SELECT);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_NUMBER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_PROJECT_PICKER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_RADIO_BUTTONS);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_SELECT_LIST);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_TEXT_FIELD);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_URL_FIELD);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_USER_PICKER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_VERSION_PICKER);
        if (edit) {
            this.tester.setWorkingForm("issue-edit");
            this.tester.selectOption("customfield_" + this.cascadingSelectId, "Cascade One");
            this.tester.selectOption("customfield_" + this.cascadingSelectId + ":1", "Cascade B");
            this.tester.assertOptionEquals("customfield_" + this.cascadingSelectId, "Cascade One");
            this.tester.assertOptionEquals("customfield_" + this.cascadingSelectId + ":1", "Cascade B");
            this.tester.setFormElement("customfield_" + this.datePickerId, "22/Aug/05");
            this.tester.assertFormElementEquals("customfield_" + this.datePickerId, "22/Aug/05");
            this.tester.setFormElement("customfield_" + this.dateTimeId, "25/Aug/05 7:00 AM");
            this.tester.assertFormElementEquals("customfield_" + this.dateTimeId, "25/Aug/05 7:00 AM");
            this.tester.setFormElement("customfield_" + this.freeTextId, "This is the default text area value\n with newlines possible\n and stuff. edited.");
            this.tester.assertFormElementEquals("customfield_" + this.freeTextId, "This is the default text area value\n with newlines possible\n and stuff. edited.");
            this.tester.setFormElement("customfield_" + this.multiCheckboxId, "10017");
            this.tester.assertFormElementEquals("customfield_" + this.multiCheckboxId, "10017");
            this.tester.setFormElement("customfield_" + this.multiSelectId, "10013");
            this.tester.assertFormElementEquals("customfield_" + this.multiSelectId, "10013");
            this.tester.setFormElement("customfield_" + this.numberId, "433");
            this.tester.assertFormElementEquals("customfield_" + this.numberId, "433");
            this.tester.setFormElement("customfield_" + this.projectPickerId, "10010");
            this.tester.assertFormElementEquals("customfield_" + this.projectPickerId, "10010");
            this.tester.setFormElement("customfield_" + this.radioButtonId, "10020");
            this.tester.assertRadioOptionSelected("customfield_" + this.radioButtonId, "10020");
            this.tester.selectOption("customfield_" + this.selectListId, "Select List Three");
            this.tester.assertFormElementEquals("customfield_" + this.selectListId, "10023");
            this.tester.setFormElement("customfield_" + this.textFieldId, "Text Field - This is the default text edited.");
            this.tester.assertFormElementEquals("customfield_" + this.textFieldId, "Text Field - This is the default text edited.");
            this.tester.setFormElement("customfield_" + this.userPickerId, "admin");
            this.tester.assertFormElementEquals("customfield_" + this.userPickerId, "admin");
            this.tester.selectOption("customfield_" + this.versionPickerId, version_oneDotTwo);
            this.tester.assertFormElementEquals("customfield_" + this.versionPickerId, TEST_CUSTOM_FIELDS_XML_VERSION_1_DOT_2_ID);
            this.tester.setFormElement("customfield_" + this.urlId, "http://www.testhis.com.au");
            this.tester.assertFormElementEquals("customfield_" + this.urlId, "http://www.testhis.com.au");
        } else {
            this.tester.assertOptionEquals("customfield_" + this.cascadingSelectId, "Cascade Three");
            this.tester.assertOptionEquals("customfield_" + this.cascadingSelectId + ":1", "Cascade Beta");
            this.tester.assertFormElementEquals("customfield_" + this.datePickerId, "23/Aug/05");
            this.tester.assertFormElementEquals("customfield_" + this.dateTimeId, "24/Aug/05 6:00 AM");
            this.tester.assertFormElementEquals("customfield_" + this.freeTextId, "\nThis is the default text area value\n with newlines possible\n and stuff.");
            this.tester.assertFormElementEquals("customfield_" + this.multiCheckboxId, "10016");
            this.tester.assertFormElementEquals("customfield_" + this.multiSelectId, "10014");
            this.tester.assertFormElementEquals("customfield_" + this.numberId, numberEntry);
            this.tester.assertFormElementEquals("customfield_" + this.projectPickerId, TEST_CUSTOM_FIELDS_XML_PRJ_HOMOSAP_ID);
            this.tester.assertRadioOptionSelected("customfield_" + this.radioButtonId, "10019");
            this.tester.assertFormElementEquals("customfield_" + this.selectListId, "10022");
            this.tester.assertFormElementEquals("customfield_" + this.textFieldId, textEntry);
            this.tester.assertFormElementEquals("customfield_" + this.urlId, urlEntry);
            this.tester.assertFormElementEquals("customfield_" + this.userPickerId, userEntry);
            this.tester.assertFormElementEquals("customfield_" + this.versionPickerId, "10010");
        }
        this.tester.setFormElement("summary", summary);
        this.tester.submit();
    }

    private void viewAndValidateIssue(boolean edited) {
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_CASCADING_SELECT);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_DATE_PICKER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_DATE_TIME);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_FREE_TEXT);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_SELECT);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_NUMBER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_PROJECT_PICKER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_RADIO_BUTTONS);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_SELECT_LIST);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_TEXT_FIELD);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_URL_FIELD);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_USER_PICKER);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_VERSION_PICKER);
        if (edited) {
            this.tester.assertTextPresent("Cascade One");
            this.tester.assertTextPresent("Cascade B");
            this.tester.assertTextPresent("22/Aug/05");
            this.tester.assertTextPresent("25/Aug/05 7:00 AM");
            this.tester.assertTextPresent(textEntry);
            this.tester.assertTextPresent("MultiCheckBox Three");
            this.tester.assertTextPresent("MultiSelect Two");
            this.tester.assertTextPresent(numberEntry);
            this.tester.assertTextPresent("homosapien");
            this.tester.assertTextPresent("Radio Three");
            this.tester.assertTextPresent("Select List Three");
            this.tester.assertTextPresent(textEntry);
            this.tester.assertTextPresent(urlEntry);
            this.tester.assertTextPresent("admin");
            this.tester.assertTextPresent(version_oneDotTwo);
        } else {
            this.tester.assertTextPresent("Cascade Three");
            this.tester.assertTextPresent("Cascade Beta");
            this.tester.assertTextPresent("23/Aug/05");
            this.tester.assertTextPresent("24/Aug/05 6:00 AM");
            this.tester.assertTextPresent(textEntry);
            this.tester.assertTextPresent("MultiCheckBox Two");
            this.tester.assertTextPresent("MultiSelect Three");
            this.tester.assertTextPresent(numberEntry);
            this.tester.assertTextPresent("homosapien");
            this.tester.assertTextPresent("Radio Two");
            this.tester.assertTextPresent("Select List Two");
            this.tester.assertTextPresent(textEntry);
            this.tester.assertTextPresent(urlEntry);
            this.tester.assertTextPresent(userEntry);
            this.tester.assertTextPresent(version_oneDotOne);
        }
    }

    private void editAndValidateIssue() {
        this.tester.clickLink("edit-issue");
        this.validateAndSetCustomFieldValues(true);
    }

    private void setupVersionPicker(String version) {
        this.versionPickerId = this.addCustomFieldInProjects("version", CUSTOM_FIELD_NAME_VERSION_PICKER, "HSP");
        this.administration.customFields().setDefaultValue(this.versionPickerId, version);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_VERSION_PICKER);
    }

    private void setupURLField(String url) {
        this.urlId = this.addCustomField("url", CUSTOM_FIELD_NAME_URL_FIELD);
        this.administration.customFields().setDefaultValue(this.urlId, url);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_URL_FIELD);
    }

    private void setupSelectList(Collection<String> options) {
        this.selectListId = this.addCustomField("select", CUSTOM_FIELD_NAME_SELECT_LIST);
        options.forEach(option -> this.administration.customFields().addOptions(this.selectListId, (String)option));
        this.administration.customFields().setDefaultValue(this.selectListId, "10022");
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_SELECT_LIST);
    }

    private void setupRadioButtons(Collection<String> options) {
        this.radioButtonId = this.addCustomField("radiobuttons", CUSTOM_FIELD_NAME_RADIO_BUTTONS);
        options.forEach(option -> this.administration.customFields().addOptions(this.radioButtonId, (String)option));
        this.administration.customFields().setDefaultValue(this.radioButtonId, "10019");
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_RADIO_BUTTONS);
    }

    private void setupNumberField(String defaultValue) {
        CustomFields customFields = this.administration.customFields();
        this.numberId = this.addCustomField("float", CUSTOM_FIELD_NAME_NUMBER);
        customFields.setCustomFieldSearcher(this.numberId, "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            customFields.setDefaultValue(this.numberId, defaultValue);
        }
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_NUMBER);
    }

    private void setupMultiCheckboxes(Collection<String> options) {
        this.multiCheckboxId = this.addCustomField("multicheckboxes", CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
        options.forEach(option -> this.administration.customFields().addOptions(this.multiCheckboxId, (String)option));
        this.administration.customFields().setDefaultValue(this.multiCheckboxId, "10016");
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
    }

    private void setupFreeText(String text) {
        this.freeTextId = this.addCustomField("textarea", CUSTOM_FIELD_NAME_FREE_TEXT);
        this.administration.customFields().setDefaultValue(this.freeTextId, text);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_FREE_TEXT);
    }

    private void setupDatePicker(String date) {
        this.datePickerId = this.addCustomField("datepicker", CUSTOM_FIELD_NAME_DATE_PICKER);
        this.administration.customFields().setDefaultValue(this.datePickerId, date);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_DATE_PICKER);
    }

    private void setupUserPicker(String user) {
        this.userPickerId = this.addCustomField("userpicker", CUSTOM_FIELD_NAME_USER_PICKER);
        this.administration.customFields().setDefaultValue(this.userPickerId, user);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_USER_PICKER);
    }

    private void setupTextField(String text) {
        this.textFieldId = this.addCustomField("textfield", CUSTOM_FIELD_NAME_TEXT_FIELD);
        this.administration.customFields().setDefaultValue(this.textFieldId, text);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_TEXT_FIELD);
    }

    private void setupProjectPicker(String projectId) {
        this.projectPickerId = this.addCustomField("project", CUSTOM_FIELD_NAME_PROJECT_PICKER);
        this.administration.customFields().setDefaultValue(this.projectPickerId, projectId);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_PROJECT_PICKER);
    }

    private void setupMultiSelect(Collection<String> options) {
        this.multiSelectId = this.addCustomField("multiselect", CUSTOM_FIELD_NAME_MULTI_SELECT);
        options.forEach(option -> this.administration.customFields().addOptions(this.multiSelectId, (String)option));
        this.administration.customFields().setDefaultValue(this.multiSelectId, "10014");
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_MULTI_SELECT);
    }

    private void setupDateTime(String dateTime) {
        this.dateTimeId = this.addCustomField("datetime", CUSTOM_FIELD_NAME_DATE_TIME);
        this.administration.customFields().setDefaultValue(this.dateTimeId, dateTime);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_DATE_TIME);
    }

    private void setupCascadingSelect() {
        this.cascadingSelectId = this.addCustomField("cascadingselect", CUSTOM_FIELD_NAME_CASCADING_SELECT);
        this.administration.customFields().addOptions(this.cascadingSelectId, "Cascade One", "Cascade Two", "Cascade Three");
        this.tester.clickLinkWithText("Cascade One");
        this.tester.setFormElement("addValue", "Cascade A");
        this.tester.submit("Add");
        this.tester.setFormElement("addValue", "Cascade B");
        this.tester.submit("Add");
        this.tester.setFormElement("addValue", "Cascade C");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("View Custom Field Configuration");
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLinkWithText("Cascade Two");
        this.tester.setFormElement("addValue", "Cascade I");
        this.tester.submit("Add");
        this.tester.setFormElement("addValue", "Cascade II");
        this.tester.submit("Add");
        this.tester.setFormElement("addValue", "Cascade III");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("View Custom Field Configuration");
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLinkWithText("Cascade Three");
        this.tester.setFormElement("addValue", "Cascade Alhpa");
        this.tester.submit("Add");
        this.tester.setFormElement("addValue", "Cascade Beta");
        this.tester.submit("Add");
        this.tester.setFormElement("addValue", "Cascade Gamma");
        this.tester.submit("Add");
        this.administration.customFields().setCascadingSelectDefaultValue(this.cascadingSelectId, "Cascade Three", "Cascade Beta");
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_CASCADING_SELECT);
    }

    @Ignore(value="FLASH-892 rewrite to WebDriver")
    @Test
    @Restore(value="TestCustomFields.xml")
    public void testAddingACustomFieldAndEditingTheConfiguration() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Version Picker Custom Field");
        this.tester.selectOption("issuetypes", "Bug");
        this.tester.checkCheckbox("global", "false");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.checkCheckbox("associatedScreens", "2");
        this.tester.checkCheckbox("associatedScreens", "3");
        this.tester.submit("Update");
        this.tester.clickLink("config_customfield_10000");
        this.tester.clickLinkWithText("Edit Default Value");
        this.tester.selectOption("customfield_10000", "New Version 1");
        this.tester.submit();
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.selectOption("issuetypes", "Bug");
        this.tester.selectOption("issuetypes", "Improvement");
        this.tester.submit();
    }

    @Test
    @RestoreBlankInstance
    public void testCustomFieldsOrderingMultiCheckboxes() {
        this.logger.log((Object)"Testing Ordering of options for multicheckboxes field");
        String fieldId = this.addCustomField("multicheckboxes", CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
        this.startCustomFieldsOrderingTest(fieldId, null);
    }

    @Test
    @RestoreBlankInstance
    public void testCustomFieldsOrderingCascadingSelect() {
        this.logger.log((Object)"Testing Ordering of options for cascading select field");
        String fieldId = this.addCustomField("cascadingselect", CUSTOM_FIELD_NAME_CASCADING_SELECT);
        String parentOption = this.startCustomFieldsOrderingTest(fieldId, null);
        this.logger.log((Object)"Testing Ordering of options for a child option of the cascading select field");
        this.startCustomFieldsOrderingTest(fieldId, parentOption);
    }

    private String startCustomFieldsOrderingTest(String fieldId, String parentOption) {
        int i;
        int numberOfOptions = 6;
        String[] optionValue = new String[6];
        String[] optionId = new String[6];
        for (i = 1; i < 6; ++i) {
            optionValue[i] = "Value_" + i;
            this.administration.customFields().goToCustomFieldConfiguration(fieldId);
            this.tester.clickLinkWithText("Edit Options");
            this.tester.assertTextPresent("Edit Options for Custom Field");
            if (parentOption != null) {
                this.tester.clickLinkWithText(parentOption);
            }
            this.tester.setFormElement("addValue", optionValue[i]);
            this.tester.submit("Add");
            this.tester.assertTextPresent(optionValue[i]);
        }
        i = 1;
        try {
            WebLink[] links;
            for (WebLink link : links = this.tester.getDialog().getResponse().getLinks()) {
                if (!link.getID().startsWith("del_")) continue;
                optionId[i] = link.getID().substring(4, 9);
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.tester.clickLinkWithText("Sort options alphabetically");
        ArrowControlledOrdering arrowControlledOrdering = new ArrowControlledOrdering(this.tester, this.textAssertions, this.page, this.logger, this.form);
        arrowControlledOrdering.checkOrderingUsingArrows(optionValue, optionId);
        return arrowControlledOrdering.checkOrderingUsingMoveToPos(optionValue, optionId, "Option");
    }

    public void customFieldsAddField() {
        this.logger.log((Object)"Test adding a custom field");
        this.fieldId_global = this.addCustomField("radiobuttons", CUSTOM_FIELD_NAME_ONE);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
    }

    public void customFieldsDeleteField() {
        this.logger.log((Object)"Test deleting a custom field");
        this.administration.customFields().removeCustomField("customfield_" + this.fieldId_global);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME_ONE);
        this.fieldId_global = this.addCustomField("radiobuttons", CUSTOM_FIELD_NAME_ONE);
        this.logger.log((Object)("Field: " + this.fieldId_global));
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
        this.fieldId_issue = this.addCustomFieldForIssueTypeNames("project", CUSTOM_FIELD_NAME_TWO, "Bug");
        this.logger.log((Object)("Field: " + this.fieldId_issue));
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_TWO);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_TWO);
        this.fieldId_project = this.addCustomFieldInProjects("datetime", CUSTOM_FIELD_NAME_THREE, "HSP");
        this.logger.log((Object)("Field: " + this.fieldId_project));
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_THREE);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_THREE);
    }

    public void customFieldsAddCustomFieldOption() {
        this.logger.log((Object)"Test adding a custom field option");
        this.administration.customFields().addOptions(this.fieldId_global, "Blue");
        this.tester.assertTextPresent("Blue");
    }

    public void customFieldsDelCustomFieldOption() {
        this.logger.log((Object)"Test deleting a custom field option");
        this.administration.customFields().removeOptions(this.fieldId_global, TEST_CUSTOM_FIELDS_XML_PRJ_HOMOSAP_ID);
        this.tester.assertTextPresent("There are currently no options available for this select list");
        this.administration.customFields().addOptions(this.fieldId_global, "Blue", "Red", "White");
    }

    public void customFieldCreateIssueWithCustomFields() {
        this.logger.log((Object)"Create an issue with custom fields");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "issue with custom fields");
        this.tester.selectOption("priority", "Minor");
        this.tester.getDialog().setFormParameter("customfield_" + this.fieldId_global, "10001");
        this.tester.assertRadioOptionSelected("customfield_" + this.fieldId_global, "10001");
        this.tester.selectOption("customfield_" + this.fieldId_issue, "homosapien");
        this.tester.setFormElement("customfield_" + this.fieldId_project, "27/Jan/05 6:00 am");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Details");
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_TWO);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_THREE);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
    }

    public void customFieldCreateIssueWithFieldScope() {
        this.logger.log((Object)"Test the availibility of custom fields using field scope for creating an issue");
        this.navigation.issue().goToCreateIssueForm("neanderthal", "Bug");
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_project);
    }

    public void customFieldsEditIssueWithCustomFields() {
        this.logger.log((Object)"Edit Issue: HSP-1 with custom fields");
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.clickLink("edit-issue");
        this.tester.getDialog().setFormParameter("customfield_" + this.fieldId_global, "10001");
        this.tester.assertRadioOptionSelected("customfield_" + this.fieldId_global, "10001");
        this.tester.selectOption("customfield_" + this.fieldId_issue, "homosapien");
        this.tester.setFormElement("customfield_" + this.fieldId_project, "27/Jan/05 6:00 am");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Details");
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_TWO);
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME_THREE);
    }

    public void customFieldEditIssueWithFieldScope() {
        this.logger.log((Object)"Test the availibility of custom fields using field scope for updating an issue");
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_3);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_2);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_project);
    }

    public void customFieldsMoveIssueWithCustomFieldsforProject() {
        this.logger.log((Object)"Test the availibility of custom fields using field scope for moving an issue to a different project");
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_3);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit();
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_project);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_global);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_2);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.navigation.issue().selectIssueType("Bug");
        this.tester.submit();
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_global);
    }

    public void customFieldsMoveIssueWithCustomFieldsforIssueType() {
        this.logger.log((Object)"Test the availibility of custom fields using field scope for moving an issue to a different issue type");
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_3);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit();
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_global);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_project);
    }

    public void customFieldCreateSubTaskWithCustomFields() {
        try {
            this.administration.subtasks().enable();
            this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
            this.tester.clickLink("create-subtask");
            this.tester.assertTextPresent("Create Sub-Task");
            this.tester.assertFormElementPresent("customfield_" + this.fieldId_project);
            this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
            this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_3);
            this.tester.clickLink("create-subtask");
            this.tester.assertTextPresent("Create Sub-Task");
            this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_project);
            this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        }
        finally {
            this.administration.subtasks().disable();
        }
    }

    public void customFieldWithFieldScreenSchemes() {
        this.logger.log((Object)"Test the availabilty of custom fields using the field screen schemes");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_global);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_project);
        this.tester.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.backdoor.screens().removeFieldFromScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
        this.backdoor.screens().removeFieldFromScreen("Default Screen", CUSTOM_FIELD_NAME_TWO);
        this.backdoor.screens().removeFieldFromScreen("Default Screen", CUSTOM_FIELD_NAME_THREE);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_global);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.tester.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_TWO);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME_THREE);
    }

    @Test
    @Restore(value="TestVersionCustomFields.xml")
    public void testVersionCustomFieldPromptsForValuesInMove() {
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("monkey");
        this.tester.submit();
        this.tester.assertTextPresent("multi version picker cf");
        this.tester.selectOption("customfield_10000", "New Version 3");
        this.tester.assertTextPresent("single version picker cf");
        this.tester.selectOption("customfield_10001", "New Version 3");
        this.tester.submit();
        this.tester.submit("Move");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertTextPresent("New Version 3");
        this.tester.assertTextNotPresent("New Version 2");
        this.tester.assertTextNotPresent("New Version 1");
    }

    @Test
    @Restore(value="TestVersionCustomFields.xml")
    public void testVersionCustomFieldPromptsForValuesInBulkMove() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.bulkOperations.chooseOperationBulkMove();
        this.navigation.issue().selectProject("monkey", "10010_1_pid");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("multi version picker cf");
        this.tester.selectOption("customfield_10000_10010", "New Version 3");
        this.tester.selectOption("customfield_10000_10011", "New Version 3");
        this.tester.assertTextPresent("single version picker cf");
        this.tester.selectOption("customfield_10001_10011", "New Version 3");
        this.navigation.clickOnNext();
        this.navigation.clickOnNext();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue("MKY-1");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10000"), "New Version 3");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10001"), "New Version 3");
        this.tester.assertTextNotPresent("New Version 2");
        this.tester.assertTextNotPresent("New Version 1");
    }

    @Test
    @Restore(value="multiuser_cf_issue_perm.xml")
    @LoginAs(user="bob")
    public void testViewIssueMultiUserCFIssueLevelSecurity() {
        this._testViewIssuePerm();
    }

    @Test
    @Restore(value="multiuser_cf_perm_scheme.xml")
    @LoginAs(user="bob")
    public void testViewIssueMultiUserCFPermissionScheme() {
        this._testViewIssuePerm();
    }

    private void _testViewIssuePerm() {
        String issueKey = TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1;
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.assertTextPresent("This is a test issue");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().createSearch("project=HSP AND issuetype=bug");
        this.tester.assertTextPresent("This is a test issue");
        this.backdoor.issues().setIssueFields(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, new IssueFields().customField(Long.valueOf(10001L), null));
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.issueNavigator().createSearch("project=HSP AND issuetype=bug");
        this.tester.assertTextNotPresent("This is a test issue");
    }

    @Test
    @RestoreBlankInstance
    public void testEditIssueTypeDoesNotCauseCustomFieldToDisappear() {
        String issueTypeName = "todo";
        String issueTypeId = this.backdoor.issueType().createIssueType("todo").getId();
        String customFieldName = "TodoTextField";
        this.addCustomFieldForIssueTypeIds("textfield", "TodoTextField", Collections.singletonList(Long.parseLong(issueTypeId)));
        this.backdoor.screens().addFieldToScreen("Default Screen", "TodoTextField");
        this.navigation.issue().goToCreateIssueForm("monkey", "todo");
        this.tester.setFormElement("summary", "testing todo");
        this.tester.setFormElement("customfield_10000", "contents of the todo field");
        this.tester.submit("Create");
        this.tester.assertTextPresent("contents of the todo field");
        this.navigation.gotoPage("/secure/admin/EditIssueType!default.jspa?id=" + issueTypeId);
        this.tester.setFormElement("name", "todo");
        this.tester.setFormElement(SYSTEM_FIELD_DESCRIPTION_ID, "a todo item");
        this.tester.submit("Update");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertTextPresent("contents of the todo field");
        this.tester.assertTextPresent("TodoTextField:");
    }

    @Test
    @Restore(value="TestSelectCustomFieldBroken.xml")
    public void testEditSelectWithMultipleValuesFixesField() {
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.clickLinkWithText(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("customfield_10010", "dude");
        this.tester.submit("Update");
        this.tester.assertTextPresent("dude");
        this.tester.assertTextPresent("select cf");
    }

    @Test
    @Restore(value="TestUserCustomFieldBroken.xml")
    public void testEditUserCFWithDeletedUsersValuesSelected() {
        this.navigation.issue().gotoIssue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("fred");
        this.tester.assertTextPresent("user cf");
        this.tester.clickLinkWithText(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Administrator");
        this.tester.assertTextPresent("user cf");
    }

    @WebTest(value={Category.TIME_ZONES})
    @Test
    @LoginAs(user="admin")
    @Restore(value="TestCustomFields.xml")
    public void testDateTimeCustomFieldShouldRespectUserTimeZone() throws Exception {
        String HSP_1 = TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1;
        String SYDNEY_TZ = "Australia/Sydney";
        String ROME_TZ = "Europe/Rome";
        this.administration.generalConfiguration().setDefaultUserTimeZone("Australia/Sydney");
        String CF_NAME = "tzAwareDateTime";
        String CF_ID = this.addCustomField("datetime", "tzAwareDateTime");
        this.backdoor.screens().addFieldToScreen("Default Screen", "tzAwareDateTime");
        String DATE_1_SYDNEY = "10/Jan/99 12:00 PM";
        String DATE_1_ROME = "10/Jan/99 2:00 AM";
        this.setCustomFieldValue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID, "10/Jan/99 12:00 PM");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99 12:00 PM"));
        this.navigation.userProfile().changeUserTimeZone("Europe/Rome");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99 2:00 AM"));
        String DATE_2_ROME = "05/Jan/99 1:00 AM";
        String DATE_2_SYDNEY = "05/Jan/99 11:00 AM";
        this.setCustomFieldValue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID, "05/Jan/99 1:00 AM");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"05/Jan/99 1:00 AM"));
        this.navigation.userProfile().changeUserTimeZone("Australia/Sydney");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"05/Jan/99 11:00 AM"));
    }

    @WebTest(value={Category.TIME_ZONES})
    @Test
    @LoginAs(user="admin")
    @Restore(value="TestCustomFields.xml")
    public void testDateCustomFieldShouldBeDisplayedInSystemTimeZone() throws Exception {
        String HSP_1 = TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1;
        String ROME_TZ = "Europe/Rome";
        String CF_NAME = "dateOnly";
        String CF_ID = this.addCustomField("datepicker", "dateOnly");
        this.backdoor.screens().addFieldToScreen("Default Screen", "dateOnly");
        String DATE_STRING_SYDNEY = "10/Jan/99";
        this.setCustomFieldValue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID, "10/Jan/99");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.administration.generalConfiguration().setDefaultUserTimeZone("Europe/Rome");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.setCustomFieldValue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID, "10/Jan/99");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.navigation.userProfile().changeUserTimeZone("Europe/Rome");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.setCustomFieldValue(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID, "10/Jan/99");
        Assert.assertThat((Object)this.customField(TEST_CUSTOM_FIELDS_XML_ISSUE_KEY_1, CF_ID).getText(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=808000)
    @Restore(value="TestCustomFieldsMissingFromContext.xml")
    public void testCustomFieldsMissingFromContext() {
        String issueKey = "GRR-1";
        this.navigation.issue().gotoIssue("GRR-1");
        this.tester.assertTextPresent("B select");
        this.tester.assertTextPresent("B radio");
        this.tester.assertTextPresent("B cascading");
        this.tester.assertTextPresent("F cascading");
        this.tester.assertTextPresent("B multi");
        this.tester.assertTextPresent("C multi");
        this.tester.assertTextPresent("B checkbox");
        this.tester.assertTextPresent("C checkbox");
        this.navigation.issue().gotoEditIssue("GRR-1");
        this.tester.assertOptionEquals("customfield_10000", "B select (not available)");
        this.tester.assertRadioOptionSelected("customfield_10001", "10004");
        this.tester.assertTextPresent("B radio (not available)");
        this.tester.assertOptionEquals("customfield_10002", "B cascading (not available)");
        this.tester.assertOptionEquals("customfield_10002:1", "F cascading (not available)");
        this.tester.assertTextPresent("B multi (not available)");
        this.tester.assertTextPresent("C multi (not available)");
        this.tester.assertTextPresent("B checkbox (not available)");
        this.tester.assertTextPresent("C checkbox (not available)");
        this.tester.submit("Update");
        this.tester.assertTextPresent("B select");
        this.tester.assertTextPresent("B radio");
        this.tester.assertTextPresent("B cascading");
        this.tester.assertTextPresent("F cascading");
        this.tester.assertTextPresent("B multi");
        this.tester.assertTextPresent("C multi");
        this.tester.assertTextPresent("B checkbox");
        this.tester.assertTextPresent("C checkbox");
        this.navigation.issue().gotoEditIssue("GRR-1");
        this.tester.selectOption("customfield_10003", "Y multi");
        this.tester.selectOption("customfield_10003", "B multi (not available)");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Invalid value &#39;10007&#39; passed for customfield &#39;Select multiple&#39;. Allowed values are: 10028[X multi], 10031[Y multi], 10034[Z multi], -1");
        this.tester.selectOption("customfield_10000", "Z select");
        this.tester.checkRadioOption("customfield_10001", "10032");
        this.tester.selectOption("customfield_10002", "X cascading");
        this.tester.selectOption("customfield_10002:1", "H cascading");
        this.tester.selectOption("customfield_10003", "Y multi");
        this.tester.uncheckCheckbox("customfield_10004");
        this.tester.checkCheckbox("customfield_10004", "10036");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Z select");
        this.tester.assertTextPresent("Y radio");
        this.tester.assertTextPresent("X cascading");
        this.tester.assertTextPresent("H cascading");
        this.tester.assertTextPresent("Y multi");
        this.tester.assertTextPresent("Z checkbox");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=808000)
    @Restore(value="TestCustomFieldsMissingFromContext.xml")
    public void testCascadingSelectWithoutChildOption() {
        String issueKey = "GRR-1";
        this.navigation.issue().gotoIssue("GRR-1");
        this.navigation.issue().gotoEditIssue("GRR-1");
        this.tester.selectOption("customfield_10002", "X cascading");
        this.tester.selectOption("customfield_10002:1", "None");
        this.tester.submit("Update");
        this.tester.assertTextPresent("X cascading");
        this.navigation.issue().gotoEditIssue("GRR-1");
        this.tester.submit("Update");
        this.tester.assertTextPresent("X cascading");
    }

    @Test
    @RestoreBlankInstance
    public void testMultipleConfigurationItemsWithoutDefaultValueItem() {
        String fieldId = this.addFuncTestCustomField("functest-textarea-multiple-configuration-items", FUNCTEST_CUSTOM_FIELD_NAME_TEXTAREA);
        this.administration.customFields().goToCustomFieldConfiguration(FieldId.fromCustomFieldId((long)Long.parseLong(fieldId)));
        this.tester.assertTextPresent("i18n configuration item 1:");
        this.tester.assertTextPresent("getViewHtml output for [customfieldtype.functest.config.item.1, configuration item 1]");
        this.tester.assertLinkPresentWithText("Edit i18n configuration item 1");
        this.tester.assertTextPresent("i18n configuration item 2:");
        this.tester.assertTextPresent("getViewHtml output for [customfieldtype.functest.config.item.2, configuration item 2]");
        this.tester.assertLinkPresentWithText("Edit i18n configuration item 2");
        this.tester.assertTextNotPresent("Default value:");
        this.tester.assertLinkNotPresentWithText("Edit Default value");
    }

    private String addCustomField(String type, String name) {
        String fullFieldType = CustomFields.builtInCustomFieldKey(type);
        String id = this.backdoor.customFields().createCustomField(name, "", fullFieldType, null);
        return CustomFields.numericCfId(id);
    }

    private String addFuncTestCustomField(String type, String name) {
        String fullFieldType = CustomFields.funcTestCustomFieldKey(type);
        String id = this.backdoor.customFields().createCustomField(name, "", fullFieldType, null);
        return CustomFields.numericCfId(id);
    }

    private String addCustomFieldForIssueTypeNames(String type, String name, String ... issueTypeNames) {
        Map issueTypes = this.backdoor.issueType().getIssueTypes().stream().collect(Collectors.toMap(IssueTypeControl.IssueType::getName, Function.identity()));
        List<Long> issueTypeIds = Arrays.asList(issueTypeNames).stream().map(issueTypeName -> Long.parseLong(((IssueTypeControl.IssueType)issueTypes.get(issueTypeName)).getId())).collect(Collectors.toList());
        return this.addCustomFieldForIssueTypeIds(type, name, issueTypeIds);
    }

    private String addCustomFieldForIssueTypeIds(String type, String name, List<Long> issueTypeIds) {
        String fullFieldType = CustomFields.builtInCustomFieldKey(type);
        String id = this.backdoor.customFields().createCustomField(name, "", fullFieldType, null);
        this.backdoor.customFields().createCustomFieldContext(CustomFields.numericCfId(id), Collections.emptyList(), issueTypeIds);
        return CustomFields.numericCfId(id);
    }

    private String addCustomFieldInProjects(String type, String name, String ... projectKeys) {
        List projectIds = Arrays.asList(projectKeys).stream().map(key -> this.backdoor.project().getProjectId((String)key)).collect(Collectors.toList());
        String fullFieldType = CustomFields.builtInCustomFieldKey(type);
        String id = this.backdoor.customFields().createCustomField(name, "", fullFieldType, null);
        this.backdoor.customFields().deleteCustomFieldContext(((CustomFieldConfig)this.backdoor.customFields().getCustomField(id, true).getConfig().get(0)).getId().toString());
        this.backdoor.customFields().createCustomFieldContext(CustomFields.numericCfId(id), projectIds, Collections.emptyList());
        return CustomFields.numericCfId(id);
    }

    private String addCustomFieldInProjectHomosapForIssueTypeIds(String type, String name, List<Long> issueTypeIds) {
        Long homosapId = this.backdoor.project().getProjectId("HSP");
        String fullFieldType = CustomFields.builtInCustomFieldKey(type);
        String id = this.backdoor.customFields().createCustomField(name, "", fullFieldType, null);
        this.backdoor.customFields().deleteCustomFieldContext(((CustomFieldConfig)this.backdoor.customFields().getCustomField(id, true).getConfig().get(0)).getId().toString());
        this.backdoor.customFields().createCustomFieldContext(CustomFields.numericCfId(id), Collections.singletonList(homosapId), issueTypeIds);
        return CustomFields.numericCfId(id);
    }

    private void setCustomFieldValue(String issueKey, String cfId, String dateString) {
        this.navigation.issue().gotoEditIssue(issueKey);
        this.tester.setFormElement(String.format("customfield_%s", cfId), dateString);
        this.tester.submit();
    }

    private CssLocator customField(String issueKey, String cfId) {
        this.navigation.issue().gotoIssue(issueKey);
        return this.locator.css(String.format("#customfield_%s-val", cfId));
    }
}

