/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS, Category.PERMISSIONS})
@LoginAs(user="admin")
public class TestCustomFieldsNoSearcherPermissions
extends BaseJiraFuncTest {
    private static final Long SCHEME_ID = 10000L;
    private static final Long SCHEME_SECURITY_LEVEL_ID = 10000L;
    private static final String USER_PICKER_CUSTOM_FIELD = "customfield_10000";
    private static final String GROUP_PICKER_CUSTOM_FIELD = "customfield_10001";
    private static final String NO_SEARCH_CUSTOM_FIELD = "customfield_10002";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestCustomFieldsNoSearcherPermissions.xml");
        this.administration.backdoor().darkFeatures().enableForSite("jira.no.frother.userpicker.field");
    }

    @After
    public void tearDown() {
        this.administration.backdoor().darkFeatures().disableForSite("jira.no.frother.userpicker.field");
    }

    @Test
    public void testEditCustomFieldSetSearcherToNone() {
        this.administration.customFields().setCustomFieldSearcher("10000", null);
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Issue Level Security Scheme(s): TestScheme");
        this.administration.customFields().setCustomFieldSearcher("10001", null);
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Issue Level Security Scheme(s): TestScheme");
    }

    @Test
    public void testDeleteCustomField() {
        this.navigation.gotoPage("/secure/admin/DeleteCustomField!default.jspa?id=10000");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): TestScheme");
        this.navigation.gotoPage("/secure/admin/DeleteCustomField!default.jspa?id=10001");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): TestScheme");
    }

    @Test
    public void testAddCustomFieldWithoutSearcherToPermission() {
        this.backdoor.darkFeatures().enableForSite("com.atlassian.jira.permission-schemes.single-page-ui.disabled");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.clickLink("add_perm_" + ProjectPermissions.CREATE_ISSUES.permissionKey());
        this.tester.checkCheckbox("type", "userCF");
        this.tester.selectOption("userCF", "nosearchercf");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("Custom field &#39;nosearchercf&#39; is not indexed for searching - please add a Search Template to this Custom Field.");
    }

    @Test
    public void testAddCustomFieldWithoutSearcherToIssueLevelPermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("add_TestLevel");
        this.tester.checkCheckbox("type", "userCF");
        this.tester.selectOption("userCF", "nosearchercf");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("Custom field &#39;nosearchercf&#39; is not indexed for searching - please add a Search Template to this Custom Field.");
    }

    @Test
    public void testAddingSearcherToCustomField() {
        this.backdoor.darkFeatures().enableForSite("com.atlassian.jira.permission-schemes.single-page-ui.disabled");
        this.administration.customFields().setCustomFieldSearcher("10001", "com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher");
        this.tester.clickLink("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("add_perm_" + ProjectPermissions.MOVE_ISSUES.permissionKey());
        this.tester.checkCheckbox("type", "userCF");
        this.tester.selectOption("userCF", "nosearchercf");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("Default Permission Scheme");
        String response = this.tester.getDialog().getResponseText();
        this.assertions.text().assertTextSequence(response, "Move Issues", "nosearchercf");
    }

    @Test
    public void testRemovingCustomField() {
        this.backdoor.permissionSchemes().removeUserCustomFieldPermission(0L, ProjectPermissions.EDIT_ISSUES, USER_PICKER_CUSTOM_FIELD);
        this.backdoor.issueSecuritySchemesControl().deleteSecurityLevel(SCHEME_ID.longValue(), SCHEME_SECURITY_LEVEL_ID.longValue());
        this.administration.customFields().removeCustomField(USER_PICKER_CUSTOM_FIELD);
        this.tester.assertTextPresent("custom fields");
        this.tester.assertTextNotPresent("User picker");
    }

    @Test
    public void testDeleteIssueSecurityLevelFlushesCache() {
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "admin");
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "TestScheme");
        this.backdoor.issueSecuritySchemesControl().addUserToSecurityLevel(SCHEME_ID.longValue(), SCHEME_SECURITY_LEVEL_ID.longValue(), "admin");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("TestLevel");
        this.tester.setFormElement(USER_PICKER_CUSTOM_FIELD, "admin");
        this.tester.submit("Update");
        this.backdoor.issueSecuritySchemesControl().deleteUserFromSecurityLevel(SCHEME_ID.longValue(), SCHEME_SECURITY_LEVEL_ID.longValue(), "admin");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("TestLevel");
        this.backdoor.issueSecuritySchemesControl().deleteUserCustomFieldFromSecurityLevel(SCHEME_ID.longValue(), SCHEME_SECURITY_LEVEL_ID.longValue(), USER_PICKER_CUSTOM_FIELD);
        this.backdoor.issueSecuritySchemesControl().deleteSecurityLevel(SCHEME_ID.longValue(), SCHEME_SECURITY_LEVEL_ID.longValue());
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextNotPresent("TestLevel");
    }
}

