/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
@LoginAs(user="admin")
public class TestDeleteCustomField
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestDeleteCustomField.xml");
    }

    @Test
    public void testRemoveCustomFieldFromNotifications() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLink("10000_edit");
        this.textAssertions.assertTextPresent(this.locator.page(), "(My Best Group)");
        this.textAssertions.assertTextPresent(this.locator.page(), "(My Friend)");
        this.administration.customFields().removeCustomField("customfield_10041");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLink("10000_edit");
        this.textAssertions.assertTextPresent(this.locator.page(), "(My Friend)");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "(My Best Group)");
        this.administration.customFields().removeCustomField("customfield_10040");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLink("10000_edit");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "(My Friend)");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "(My Best Group)");
    }
}

