/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.search.AutoCompleteField;
import com.atlassian.jira.functest.framework.backdoor.search.JqlAutoCompleteControl;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
public class TestMultiCheckboxCustomFieldOptions
extends BaseJiraFuncTest {
    private static final String CUSTOM_FIELD_ID = "10003";
    private static final String CUSTOMFIELD_LONG_ID = "customfield_10003";
    private static final String OPTION_00 = "10014";
    private static final String OPTION_01 = "10011";
    private static final String OPTION_02 = "10012";
    private static final String OPTION_03 = "10013";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Suzuki");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.tester.assertTextPresent("Honda");
        this.tester.assertTextPresent("Kawasaki");
        this.tester.assertTextPresent("Yamaha");
        this.tester.assertTextPresent("Suzuki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Aprilia");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.tester.assertTextPresent("Fiat");
        this.tester.assertTextPresent("Lambretta");
        this.tester.assertTextPresent("Vespa");
        this.tester.assertTextPresent("Aprilia");
    }

    @Test
    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.locator.id("customfield_10003-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Aprilia");
        this.locator.id("customfield_10003-value-default").getText().contains("Honda");
    }

    @Test
    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10003");
        this.tester.assertTextNotPresent("(disabled)");
    }

    @Test
    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_03, "Suzuki");
        this.locator.id("customfield_10003-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("MultiCheckboxesField = Honda ORDER BY key ASC", "HSP-11", "HSP-12");
        this.createSearchAndAssertIssues("MultiCheckboxesField = Kawasaki ORDER BY key ASC", "HSP-10", "HSP-12");
    }

    @Test
    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        Assert.assertTrue((!this.locator.id("customfield_10003-1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
    }

    @Test
    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_01);
        this.navigation.issue().gotoEditIssue("HSP-11");
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        Assert.assertTrue((!this.locator.id("customfield_10003-2").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-11");
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        Assert.assertTrue((!this.locator.id("customfield_10003-2").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_01);
        this.navigation.issue().gotoEditIssue("HSP-11");
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-1").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-3").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10003-4").exists());
    }

    @Test
    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        Iterable<AutoCompleteField> jqlFieldz = new JqlAutoCompleteControl(this.environmentData).getJqlFieldz();
        Assert.assertThat(jqlFieldz, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"displayName", (Matcher)Matchers.containsString((String)"cf[10003]"))));
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

