/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.search.AutoCompleteField;
import com.atlassian.jira.functest.framework.backdoor.search.JqlAutoCompleteControl;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
public class TestRadioSelectCustomFieldOptions
extends BaseJiraFuncTest {
    private static final String CUSTOM_FIELD_ID = "10006";
    private static final String CUSTOMFIELD_LONG_ID = "customfield_10006";
    private static final String OPTION_00 = "10019";
    private static final String OPTION_01 = "10020";
    private static final String OPTION_02 = "10021";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreData("TestSelectCustomFieldOptions.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testEditOptions() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.tester.assertTextPresent("Honda");
        this.tester.assertTextPresent("Kawasaki");
        this.tester.assertTextPresent("Yamaha");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Fiat");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Lambretta");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Vespa");
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.tester.assertTextPresent("Fiat");
        this.tester.assertTextPresent("Lambretta");
        this.tester.assertTextPresent("Vespa");
    }

    @Test
    public void testDefaultShowsUpdatedOption() throws SAXException {
        this.administration.customFields().setDefaultValue(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.locator.id("customfield_10006-value-default").getText().contains("option 00");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10006-value-default").getText().contains("Honda");
    }

    @Test
    public void testDisable() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"option 00", "(disabled)"});
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=10006");
        this.tester.assertTextNotPresent("(disabled)");
    }

    @Test
    public void testSearchNewValues() throws SAXException {
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_00, "Honda");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_01, "Kawasaki");
        this.administration.customFields().editOptionValue(CUSTOM_FIELD_ID, OPTION_02, "Yamaha");
        this.locator.id("customfield_10006-value-default").getText().contains("Honda");
        this.administration.reIndex();
        this.createSearchAndAssertIssues("RadioButtonsField = Honda ORDER BY key ASC", "HSP-11");
        this.createSearchAndAssertIssues("RadioButtonsField = Kawasaki ORDER BY key ASC", "HSP-10");
    }

    @Test
    public void testDisabledNotValidForCreate() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        Assert.assertTrue((!this.locator.id("customfield_10006-1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-1").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
    }

    @Test
    public void testDisabledNotValidForEdit() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        Assert.assertTrue((!this.locator.id("customfield_10006-1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
        this.navigation.issue().gotoEditIssue("HSP-11");
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-1").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
        this.administration.customFields().enableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issue().gotoEditIssue("HSP-10");
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-1").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-2").exists());
        Assert.assertTrue((boolean)this.locator.id("customfield_10006-3").exists());
    }

    @Test
    public void testDisabledValidForSearch() throws SAXException {
        this.administration.customFields().disableOptions(CUSTOM_FIELD_ID, OPTION_00);
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        Iterable<AutoCompleteField> jqlFieldz = new JqlAutoCompleteControl(this.environmentData).getJqlFieldz();
        Assert.assertThat(jqlFieldz, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"displayName", (Matcher)Matchers.containsString((String)"cf[10006]"))));
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

