/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import javax.inject.Inject;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
@Restore(value="blankprojects.xml")
@LoginAs(user="admin")
public class TestReadOnlyTextCustomFieldSelector
extends BaseJiraFuncTest {
    public static final String CUSTOM_FIELD_NAME = "myreadonlytextfield";
    public static final String ISSUE_SUMMARY = "This is my summary";
    @Inject
    private CustomFields customFields;

    @Test
    public void testReadOnlyTextNoXXS() throws SAXException {
        String customFieldId = this.backdoor.customFields().createCustomField(CUSTOM_FIELD_NAME, "", CustomFields.builtInCustomFieldKey("readonlyfield"), null);
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", ISSUE_SUMMARY);
        IssueFields fields = new IssueFields();
        Long fieldId = Long.valueOf(CustomFields.numericCfId(customFieldId));
        fields.customField(fieldId, (Object)"<script>alert(0);</script>");
        this.backdoor.issues().setIssueFields(issue.key(), fields);
        this.navigation.issue().viewIssue(issue.key());
        this.tester.assertTextPresent("&lt;script&gt;alert(0);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert(0);</script>");
    }
}

