/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMPONENTS_AND_VERSIONS, Category.CUSTOM_FIELDS, Category.FIELDS})
@LoginAs(user="admin")
public class TestVersionCustomField
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testOrderingOfOptions() {
        this.administration.restoreData("TestVersionCustomField.xml");
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue 1");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        List<String> fixForVersions = Arrays.asList(this.tester.getDialog().getOptionsFor("fixVersions"));
        List<String> affectsVersions = Arrays.asList(this.tester.getDialog().getOptionsFor("versions"));
        List<String> cfSingleVersions = Arrays.asList(this.tester.getDialog().getOptionsFor("customfield_10000"));
        List<String> cfVersions = Arrays.asList(this.tester.getDialog().getOptionsFor("customfield_10001"));
        Assert.assertEquals((Object)EasyList.build((Object)"New Version 5", (Object)"New Version 6", (Object)"New Version 4", (Object)"New Version 1"), (Object)this.getUnifiedVersions(fixForVersions));
        Assert.assertEquals((Object)EasyList.build((Object)"New Version 4", (Object)"New Version 1", (Object)"New Version 5", (Object)"New Version 6"), (Object)this.getUnifiedVersions(affectsVersions));
        Assert.assertEquals((Object)this.getUnifiedVersions(cfSingleVersions), (Object)this.getUnifiedVersions(affectsVersions));
        Assert.assertEquals((Object)this.getUnifiedVersions(cfVersions), (Object)this.getUnifiedVersions(affectsVersions));
    }

    private List getUnifiedVersions(List<String> options) {
        ArrayList<Object> allVersions;
        if (options.contains("Unknown")) {
            allVersions = new ArrayList<String>(options);
            allVersions.remove("Unknown");
        } else {
            allVersions = new ArrayList();
            allVersions.addAll(this.getReleasedVersions(options, 2));
            allVersions.addAll(this.getUnreleasedVersions(options, 2));
        }
        return allVersions;
    }

    private List getReleasedVersions(List<String> options, int expected) {
        return this.getVersions(options, expected, "Released Versions");
    }

    private List getUnreleasedVersions(List<String> options, int expected) {
        return this.getVersions(options, expected, "Unreleased Versions");
    }

    private List getVersions(List<String> options, int expected, String flag) {
        int i = options.indexOf(flag) + 1;
        return options.subList(i, i + expected);
    }
}

