/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
@LoginAs(user="admin")
@Restore(value="BaseProfessionalPortalPage.xml")
public class TestAddPortalPageSharing
extends BaseJiraFuncTest {
    private static final Long CLONE_BLANK = null;
    private static final int PROJECT_HIDDENFROMFRED_ID = 10010;
    private static final int PROJECT_HOMOSAPIEN_ID = 10000;
    private static final String PROJECT_HOMOSAPIEN_NAME = "homosapien";
    private static final int PERMISSION_CREATE_SHARED = 22;
    private static final int USERS_ROLE_ID = 10000;
    private static final int ROLE_ADMIN_ID = 10002;
    private static final String ROLE_ADMIN_NAME = "admin-role";
    private static final String USERS_ROLE_NAME = "Users";
    private static final String GROUP_JIRA_USERS = "jira-users";
    private static final String GROUP_JIRA_DEVELOPERS = "jira-developers";
    private static final String GROUP_SHARINGUSERS = "sharing_users";
    private static final String USER_FRED = "fred";
    private static final SharedEntityInfo PAGE_FRED_PRIVATE = new SharedEntityInfo(10010L, "PrivateFredDashboard", null, true, TestSharingPermissionUtils.createPrivatePermissions());
    private static final SharedEntityInfo PAGE_FRED_PUBLIC = new SharedEntityInfo(10011L, "PublicFredDashboard", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final List<SharedEntityInfo> ORIGINAL_PAGES = Arrays.asList(PAGE_FRED_PRIVATE, PAGE_FRED_PUBLIC);
    @Inject
    private Administration administration;

    private static Set<TestSharingPermission> createGroupPermission(String group) {
        return Collections.singleton(new GroupTestSharingPermission(group));
    }

    private static Set<TestSharingPermission> createProjectPermission(long projectId, String projectName) {
        return Collections.singleton(new ProjectTestSharingPermission(projectId, projectName));
    }

    private static Set<TestSharingPermission> createProjectPermission(long projectId, String projectName, long roleId, String roleName) {
        return Collections.singleton(new ProjectTestSharingPermission(projectId, roleId, projectName, roleName));
    }

    private static List<SharedEntityInfo> createExpectedList(SharedEntityInfo page) {
        return Arrays.asList(PAGE_FRED_PRIVATE, PAGE_FRED_PUBLIC, page);
    }

    @Test
    public void testPublicDefaultState() {
        this.navigation.userProfile().changeUserSharingType(true);
        this.tester.gotoPage("secure/AddPortalPage!default.jspa");
        Assert.assertEquals(TestSharingPermissionUtils.createAuthenticatedPermissions(), this.parseSharingPermissions());
    }

    @Test
    public void testPrivateDefaultState() {
        this.navigation.userProfile().changeUserSharingType(false);
        this.tester.gotoPage("secure/AddPortalPage!default.jspa");
        Assert.assertEquals(TestSharingPermissionUtils.createPrivatePermissions(), this.parseSharingPermissions());
    }

    @Test
    public void testCreateDashboardPagePrivate() {
        SharedEntityInfo page = new SharedEntityInfo("testCreateSharePrivate", null, true, TestSharingPermissionUtils.createPrivatePermissions());
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testCreateDashboardPagePublic() {
        SharedEntityInfo page = new SharedEntityInfo("testCreateDashboardPagePublic", "Description for testCreateDashboardPagePublic", true, TestSharingPermissionUtils.createPublicPermissions());
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testCreateDashboardPageGroup() {
        SharedEntityInfo page = new SharedEntityInfo("testCreateDashboardGroup", "Description for testCreateDashboardGroup", true, TestAddPortalPageSharing.createGroupPermission(GROUP_JIRA_USERS));
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testCreateDashboardPageProject() {
        SharedEntityInfo page = new SharedEntityInfo("testCreateDashboardGroup", "Description for testCreateDashboardGroup", true, TestAddPortalPageSharing.createProjectPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testCreateDashboardPageProjectAndRole() {
        SharedEntityInfo page = new SharedEntityInfo("testCreateDashboardPageProjectAndRole", "Description for testCreateDashboardPageProjectAndRole", true, TestAddPortalPageSharing.createProjectPermission(10000L, PROJECT_HOMOSAPIEN_NAME, 10000L, USERS_ROLE_NAME));
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testCreateDashboardWithMultipleShares() {
        HashSet<TestSharingPermission> permissions = new HashSet<TestSharingPermission>();
        permissions.add(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, USERS_ROLE_NAME));
        permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        permissions.add(new GroupTestSharingPermission(GROUP_JIRA_USERS));
        SharedEntityInfo page = new SharedEntityInfo("testCreateDashboardWithMultipleShares", "Description for testCreateDashboardWithMultipleShares", true, permissions);
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testCantCreateDashboardGroupDoesNotExist() {
        SharedEntityInfo page = new SharedEntityInfo("testCantCreateDashboardGroupDoesNotExist", "Description for testCantCreateDashboardGroupDoesNotExist", true, TestAddPortalPageSharing.createGroupPermission("thisGroupDoesNotExistInTheTestDataOrElseItWasVeryLucky"));
        this._testPageNotCreated(page, "Group: 'thisGroupDoesNotExistInTheTestDataOrElseItWasVeryLucky' does not exist, or you do not have permission to share it.");
    }

    @Test
    public void testCantCreateDashboardGroupNotMember() {
        this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            SharedEntityInfo page = new SharedEntityInfo("testCantCreateDashboardGroupNotMember", "Description for testCantCreateDashboardGroupNotMember", true, TestAddPortalPageSharing.createGroupPermission(GROUP_JIRA_DEVELOPERS));
            this._testPageNotCreated(page, "Group: 'jira-developers' does not exist, or you do not have permission to share it.");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCanCreateDashboardGroupNotMemberAndFeatureFlagIsOn() {
        this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardGroupNotMemberAndFeatureFlagIsOn", "Description for testCanCreateDashboardGroupNotMemberAndFeatureFlagIsOn", true, TestAddPortalPageSharing.createGroupPermission(GROUP_JIRA_DEVELOPERS));
            this._testPageCreatedCorrectly(page);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCantCreateDashboardGroupNameEmpty() {
        SharedEntityInfo page = new SharedEntityInfo("testCantCreateDashboardGroupNameEmpty", "Description for testCantCreateDashboardGroupNameEmpty", true, TestAddPortalPageSharing.createGroupPermission(null));
        this._testPageNotCreated(page, "Group permission is not valid: Invalid group name ''.");
    }

    @Test
    public void testCanCreateDashboardProjectDoesNotExist() {
        SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardProjectDoesNotExist", null, true, TestAddPortalPageSharing.createProjectPermission(100L, null));
        this._testPageNotCreated(page, "Selected project does not exist.");
    }

    @Test
    public void testCantCreateDashboardProjectCantSee() {
        this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardProjectCantSee", null, true, TestAddPortalPageSharing.createProjectPermission(10010L, null));
            this._testPageNotCreated(page, "You do not have permission to share with Project: [Unknown Project].");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCanCreateDashboardProjectCantSee() {
        this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardProjectCantSee", null, true, TestAddPortalPageSharing.createProjectPermission(10010L, null));
            this._testPageCreatedCorrectly(page);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCanCreateDashboardRoleDoesNotExist() {
        SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardRoleDoesNotExist", null, true, TestAddPortalPageSharing.createProjectPermission(10000L, null, 123L, null));
        this._testPageNotCreated(page, "Selected role does not exist.");
    }

    @Test
    public void testCantCreateDashboardRoleCantSee() {
        this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardRoleCantSee", null, true, TestAddPortalPageSharing.createProjectPermission(10000L, null, 10002L, null));
            this._testPageNotCreated(page, "You do not have permission to share with Project: 'homosapien' Role: [Unknown Role].");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testCanCreateDashboardRoleCantSee() {
        this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        try {
            SharedEntityInfo page = new SharedEntityInfo("testCanCreateDashboardRoleCantSee", null, true, TestAddPortalPageSharing.createProjectPermission(10000L, PROJECT_HOMOSAPIEN_NAME, 10002L, ROLE_ADMIN_NAME));
            this._testPageCreatedCorrectly(page);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testReallyBadShare() {
        SharedEntityInfo page = new SharedEntityInfo("testReallyBadShare", null, true, Collections.singleton(new SimpleTestSharingPermission("badType")));
        this._testPageNotCreated(page, "Share permission of type 'badType' is unknown.");
    }

    @Test
    public void testReallyBadShareCombination() {
        HashSet<TestSharingPermission> permissions = new HashSet<TestSharingPermission>();
        permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        permissions.add(new GlobalTestSharingPermission());
        SharedEntityInfo page = new SharedEntityInfo("testCreateDashboardWithMultipleShares", "Description for testCreateDashboardWithMultipleShares", true, permissions);
        this._testPageNotCreated(page, "Permission type 'global' must not be included with other permissions.");
    }

    @Test
    public void testUserCantSeeSharingOptionsWithoutPermission() {
        this.administration.removeGlobalPermission(22, GROUP_SHARINGUSERS);
        this.tester.gotoPage("secure/AddPortalPage!default.jspa");
        this.tester.assertTextNotPresent("Shares:");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id = 'share_div']");
        Assert.assertNull((Object)locator.getNode());
        SharedEntityInfo page = new SharedEntityInfo("testUserCantSeeSharingOptionsWithoutPermission", null, true, null);
        this._testPageCreatedCorrectly(page);
    }

    @Test
    public void testUserCantSaveSharesWithoutPermission() {
        this.administration.removeGlobalPermission(22, GROUP_SHARINGUSERS);
        SharedEntityInfo page = new SharedEntityInfo("testUserCantSaveSharesWithoutPermission", null, true, TestSharingPermissionUtils.createPublicPermissions());
        this._testPageNotCreated(page, "You do not have permission to share. All shares are invalid.");
    }

    private void _testPageNotCreated(SharedEntityInfo page, String expectedErrorMessage) {
        this.loginAs(USER_FRED);
        this.navigation.dashboard().addPage(page, CLONE_BLANK);
        if (this.backdoor.darkFeatures().isGlobalEnabled("com.atlassian.jira.sharedEntityEditRights")) {
            this.assertions.getJiraFormAssertions().assertFormErrMsg(expectedErrorMessage);
        } else {
            this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(expectedErrorMessage);
        }
        this.navigation.dashboard().navigateToFavourites();
        this.assertions.getDashboardAssertions().assertDashboardPages(ORIGINAL_PAGES, Dashboard.Table.FAVOURITE);
    }

    private void _testPageCreatedCorrectly(SharedEntityInfo page) {
        this.loginAs(USER_FRED);
        this.navigation.dashboard().addPage(page, CLONE_BLANK);
        this.navigation.dashboard().navigateToFavourites();
        this.assertions.getDashboardAssertions().assertDashboardPages(TestAddPortalPageSharing.createExpectedList(page), Dashboard.Table.FAVOURITE);
    }

    private void loginAs(String userName) {
        this.navigation.login(userName, userName);
    }

    private Set<TestSharingPermission> parseSharingPermissions() {
        XPathLocator locator = new XPathLocator(this.tester, "//span[@id='shares_data_editors']");
        try {
            return TestSharingPermissionUtils.parsePermissions(locator.getText());
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to parse JSON shares.", e);
        }
    }
}

