/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.management;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
@LoginAs(user="admin")
@RestoreOnce(value="TestSharedDashboards.xml")
public class TestSharedDashboardSearchingByAdmins
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testDashboardNameIsALink() {
        this.administration.sharedDashboards().goTo().searchAll();
        this.tester.assertLinkPresent("dashboardlink_10000");
        this.tester.assertLinkPresentWithText("System Dashboard");
    }

    @Test
    public void testAnAdminIsAbleToSearchForDashboardsSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10015L).name("Shared Dashboard with group jira-developers owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        MatcherAssert.assertThat(actualDashboardItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForDashboardsSharedWithAGroupHeBelongsTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10014L).name("Shared Dashboard with Anyone owned by developer").owner("Developer (developer)").build(), (Object)new DashboardItem.Builder().id(10010L).name("Shared Dashboard with group jira-administrators owned by admin").owner("Administrator (admin)").build(), (Object)new DashboardItem.Builder().id(10018L).name("Shared Dashboard with group jira-users owned by fred").owner("Fred Normal (fred)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        MatcherAssert.assertThat(actualDashboardItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForDashboardsSharedWithARoleHeIsNotPartOf() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10016L).name("Shared Dashboard with role Developers on homosapiens owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        MatcherAssert.assertThat(actualDashboardItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForDashboardsSharedWithARoleHeIsPartOf() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10019L).name("Shared Dashboard with role Users on homosapien owned by fred").owner("Fred Normal (fred)").build(), (Object)new DashboardItem.Builder().id(10013L).name("Shared Dashboard with all roles on Monkey owned by developer").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
        Assert.assertNotNull(actualDashboardItems);
        MatcherAssert.assertThat(actualDashboardItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForDashboardsThatArePrivate() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10011L).name("Private Dashboard owned by admin").owner("Administrator (admin)").build());
            List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
            Assert.assertNotNull(actualDashboardItems);
            MatcherAssert.assertThat(actualDashboardItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
            Assert.assertTrue((boolean)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testAnAdminIsNotAbleToSearchForDashboardsThatArePrivateWithFfDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            ImmutableList nonExpectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10011L).name("Private Dashboard owned by admin").owner("Administrator (admin)").build());
            List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().dashboards().list();
            Assert.assertNotNull(actualDashboardItems);
            MatcherAssert.assertThat(actualDashboardItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
            Assert.assertTrue((boolean)Iterables.all((Iterable)nonExpectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }
}

