/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import org.junit.Test;
import org.junit.jupiter.api.BeforeEach;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
@Restore(value="TestAverageAgeReportShowsProjectName.xml")
public class TestAverageAgeReportShowsProjectName
extends BaseJiraFuncTest {
    private static final String PROJECT_NAME = "hello project";
    private static final String AVERAGE_AGE_REPORT_URL = "secure/ConfigureReport.jspa?projectOrFilterId=project-10200&periodName=daily&daysprevious=30&selectedProjectId=10200&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Aaverageage-report&Next=Next";

    @BeforeEach
    public void beforeEach() {
        this.navigation.logout();
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=815000)
    public void userWithoutPermissionDoesntSeeProjectName() {
        this.navigation.login("hello", "hello");
        this.tester.gotoPage(AVERAGE_AGE_REPORT_URL);
        this.tester.assertTextPresent("The project you requested does not exist or you do not have permission to view it.");
        this.tester.assertTextNotPresent(PROJECT_NAME);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=815000)
    public void userWithPermissionSeesProjectName() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(AVERAGE_AGE_REPORT_URL);
        this.tester.assertTextPresent(PROJECT_NAME);
    }
}

