/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestConfigureReport
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testConfigureReportWithInvalidReportKey() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.tester.assertTextPresent("Report: Single Level Group By Report");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&amp;reportKey=com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.assertions.forms().assertFormErrMsg("No report was specified.  The 'reportKey' parameter was empty.");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Report:", "Single Level Group By Report", "Filter is a required field"});
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&amp;reportKey=com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.assertions.forms().assertFormErrMsg("No report was specified.  The 'reportKey' parameter was empty.");
    }

    @Test
    public void testConfigureReportWithMissingReportKey() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=plugin.key:module.key");
        this.assertions.forms().assertFormErrMsg("Found no available report with key 'plugin.key:module.key'");
    }

    @Test
    public void testRedirectsOldReportsKeysToTheCoreReportsPlugin() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Asinglelevelgroupby");
        this.tester.assertTextPresent("Report: Single Level Group By Report");
    }

    @Test
    public void testDisplaysErrorWhenReportKeyDoesNotExist() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:notfound");
        this.tester.assertTextPresent("Configure Report - Error");
    }
}

