/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.dashboard.reports.AbstractConfigureReportFieldTestCase;
import org.junit.Test;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestConfigureReportCheckboxField
extends AbstractConfigureReportFieldTestCase {
    private Element fieldContainer() {
        return (Element)new XPathLocator(this.tester, "//div[@class = 'field-group'][descendant::input[@type = 'checkbox'][@id = 'aCheckbox']]").getNode();
    }

    @Test
    public void fieldExists() {
        this.tester.assertFormElementPresent("aCheckbox");
    }

    @Test
    public void fieldLabelRendered() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "label"), "A checkbox");
    }

    @Test
    public void fieldDescriptionRendered() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "descendant::label[@for='aCheckbox']"), "This is a checkbox field");
    }

    @Test
    public void validationErrorsRendered() {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.dev.func-test-plugin:fieldtest-report&aString=fail");
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "*[@class='errMsg']"), "This checkbox field has an error");
    }

    @Test
    public void valueIsSubmittedToReportBean() {
        this.tester.setFormElement("aCheckbox", "true");
        this.tester.submit();
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//tr[th = 'aCheckbox']/td"), "true");
    }
}

