/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.dashboard.reports.AbstractConfigureReportFieldTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLSelectElement;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestConfigureReportMultiSelectField
extends AbstractConfigureReportFieldTestCase {
    @Test
    public void fieldExists() {
        this.tester.assertFormElementPresent("aMultiSelect");
    }

    @Test
    public void defaultValueIsPresent() {
        HTMLSelectElement element = (HTMLSelectElement)this.tester.getDialog().getElement("aMultiSelect_select");
        int selectedIndex = element.getSelectedIndex();
        Node selected = element.getOptions().item(selectedIndex);
        Assert.assertThat((Object)selected.getTextContent(), (Matcher)Matchers.is((Object)"Green"));
    }

    @Test
    public void fieldLabelRendered() {
        this.textAssertions.assertTextPresent("A multiselect");
    }

    @Test
    public void fieldDescriptionRendered() {
        this.textAssertions.assertTextPresent("This is a multiselect field");
    }

    @Test
    public void validationErrorsRendered() {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.dev.func-test-plugin:fieldtest-report&aString=fail");
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "*[@class='errMsg']"), "This multi select field has an error");
    }

    @Test
    public void allItemsAreInList() {
        Assert.assertThat((Object)this.tester.getDialog().getOptionValuesFromSelectList("aMultiSelect"), (Matcher)Matchers.arrayContaining((Object[])new String[]{"multivalue-red", "multivalue-green", "multivalue-blue", "multivalue-yellow", "multivalue-orange"}));
    }

    private Element fieldContainer() {
        return (Element)new XPathLocator(this.tester, "//div[@class = 'field-group'][select[@id = 'aMultiSelect_select']]").getNode();
    }

    @Test
    public void valueIsSubmittedToReportBean() {
        this.tester.setFormElement("aMultiSelect", "multivalue-orange");
        this.tester.submit();
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//tr[th = 'aMultiSelect']/td"), "multivalue-orange");
    }
}

