/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.dashboard.reports.AbstractConfigureReportFieldTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestConfigureReportSelectField
extends AbstractConfigureReportFieldTestCase {
    private Element fieldContainer() {
        return (Element)new XPathLocator(this.tester, "//div[@class = 'field-group'][select[@id = 'aSelect_select']]").getNode();
    }

    @Test
    public void fieldExists() {
        this.tester.assertFormElementPresent("aSelect");
    }

    @Test
    public void defaultValueIsFilledIn() {
        this.formAssertions.assertSelectElementHasOptionSelected("aSelect", "Two");
    }

    @Test
    public void allItemsAreInList() {
        Assert.assertThat((Object)this.tester.getDialog().getOptionValuesFromSelectList("aSelect"), (Matcher)Matchers.arrayContaining((Object[])new String[]{"value-one", "value-two", "value-three", "value-four", "value-five"}));
    }

    @Test
    public void fieldLabelRendered() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "label"), "A select");
    }

    @Test
    public void fieldDescriptionRendered() {
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "descendant::label[@for='aSelect_select']"), "This is a select field");
    }

    @Test
    public void validationErrorsRendered() {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.dev.func-test-plugin:fieldtest-report&aString=fail");
        this.textAssertions.assertTextPresent(new XPathLocator(this.fieldContainer(), "*[@class='errMsg']"), "This select field has an error");
    }

    @Test
    public void valueIsSubmittedToReportBean() {
        this.tester.setFormElement("aSelect", "value-three");
        this.tester.submit();
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//tr[th = 'aSelect']/td"), "value-three");
    }
}

