/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestDeveloperWorkloadReport
extends BaseJiraFuncTest {
    @Inject
    protected Navigation navigation;
    @Inject
    protected TableAssertions tableAssertions;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestDeveloperWorkloadReport.xml");
    }

    @Test
    public void testDeveloperWorkloadReportBasic() {
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.submit("Next");
        this.assertBasicTestReport();
    }

    private void assertBasicTestReport() {
        this.tester.assertTextPresent("User Workload Report");
        WebTable table = this.getTable();
        this.tableAssertions.assertTableContainsRow(table, new String[]{"homosapien", "3", "1 week, 1 day, 1 hour"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"monkey", "3", "18 minutes"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"Total", "6", "1 week, 1 day, 1 hour, 18 minutes"});
    }

    @Test
    public void testPreSubtaskInclusionUrls() {
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.assertTextPresent("Sub-task Inclusion");
        this.tester.assertTextPresent("Only including sub-tasks assigned to the selected user");
        this.tester.assertTextPresent("Also including unassigned sub-tasks");
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?developer=admin&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Adeveloper-workload&Next=Next");
        this.assertBasicTestReport();
    }

    @Test
    public void testSubtaskInclusionOnlyAssignee() {
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.selectOption("subtaskInclusion", "Only including sub-tasks assigned to the selected user");
        this.tester.submit("Next");
        this.assertBasicTestReport();
    }

    @Test
    public void testSubtaskInclusionOnlyAssigneeWithSubtasks() {
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String subtask = this.navigation.issue().createSubTask("MKY-1", "Sub-task", "curious george is a monkey", "he is always getting into trouble", "2h");
        this.navigation.issue().logWorkWithComment(subtask, "1h", "work it george");
        this.navigation.issue().unassignIssue(subtask, "unassigning");
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.selectOption("subtaskInclusion", "Only including sub-tasks assigned to the selected user");
        this.tester.submit("Next");
        this.assertBasicTestReport();
    }

    @Test
    public void testSubtaskInclusionOnlyAssigneeWithSubtasksOnIssues() {
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String subtask = this.navigation.issue().createSubTask("MKY-1", "Sub-task", "curious george is a monkey", "he is always getting into trouble", "2h");
        this.navigation.issue().logWork(subtask, "1h");
        this.navigation.issue().unassignIssue(subtask, null);
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.selectOption("subtaskInclusion", "Only including sub-tasks assigned to the selected user");
        this.tester.submit("Next");
        this.assertBasicTestReport();
    }

    @Test
    public void testSubtaskInclusionAlsoUnassigned() {
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String subtask = this.navigation.issue().createSubTask("MKY-1", "Sub-task", "curious george is a monkey", "he is always getting into trouble", "2h");
        this.navigation.issue().logWork(subtask, "1h");
        this.navigation.issue().unassignIssue(subtask, null);
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.selectOption("subtaskInclusion", "Also including unassigned sub-tasks");
        this.tester.submit("Next");
        this.tester.assertTextPresent("User Workload Report");
        WebTable table = this.getTable();
        this.tableAssertions.assertTableContainsRow(table, new String[]{"homosapien", "3", "1 week, 1 day, 1 hour"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"monkey", "4", "1 hour, 18 minutes"});
        this.tableAssertions.assertTableContainsRow(table, new String[]{"Total", "7", "1 week, 1 day, 2 hours, 18 minutes"});
    }

    @Test
    public void testDeveloperWorkloadReportConfigPageIsUnavailableWhenTimeTrackingIsDisabled() {
        this.disableTimeTracking();
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.assertions.forms().assertFormErrMsg("Found no available report with key 'com.atlassian.jira.jira-core-reports-plugin:developer-workload'");
    }

    @Test
    public void testDeveloperWorkloadGenerationIsUnavailableWhenTimeTrackingIsDisabled() {
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.disableTimeTracking();
        this.tester.submit("Next");
        this.assertions.forms().assertFormErrMsg("Found no available report with key 'com.atlassian.jira.jira-core-reports-plugin:developer-workload'");
    }

    private void disableTimeTracking() {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", false);
    }

    private WebTable getTable() {
        try {
            return this.tester.getDialog().getResponse().getTableWithID("dwreport");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

