/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.REPORTS})
@LoginAs(user="admin")
public class TestDeveloperWorkloadReportPermissions
extends BaseJiraFuncTest {
    private final Report report = new Report();
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestDeveloperWorkloadReportPermissions.xml");
    }

    @Test
    public void test() {
        this.navigation.login("admin", "admin");
        this._testAdminUserDeveloperWorkloadReportAdminLogin();
        Object tests = new AdminLoginTests();
        ((AdminLoginTests)tests).testFredUser();
        ((AdminLoginTests)tests).testFredUserWithSubTasks();
        ((AdminLoginTests)tests).testBobUser();
        ((AdminLoginTests)tests).testBobUserWithSubTasks();
        this.navigation.login("fred", "fred");
        this._testAdminUserDeveloperWorkloadReportAdminLogin();
        tests = new FredLoginTests();
        ((FredLoginTests)tests).testFredUser();
        ((FredLoginTests)tests).testFredUserWithSubTasks();
        ((FredLoginTests)tests).testBobUser();
        ((FredLoginTests)tests).testBobUserWithSubTasks();
        this.navigation.login("bob", "bob");
        this._testAdminUserDeveloperWorkloadReportAdminLogin();
        tests = new BobLoginTests();
        ((BobLoginTests)tests).testFredUser();
        ((BobLoginTests)tests).testFredUserWithSubTasks();
        ((BobLoginTests)tests).testBobUser();
        ((BobLoginTests)tests).testBobUserWithSubTasks();
    }

    private void _testAdminUserDeveloperWorkloadReportAdminLogin() {
        this.report.generateWithoutSubtasks("admin");
        this.tester.assertTextPresent("User Workload Report");
        this.tester.assertTextPresent("There are no unresolved issues assigned to the specified user");
    }

    private class Report {
        private static final String REPORT = "secure/ConfigureReport.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin%3Adeveloper-workload&Next=Next";
        private static final String CONFIG = "/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload";

        private Report() {
        }

        void configure() {
            TestDeveloperWorkloadReportPermissions.this.navigation.gotoPage(CONFIG);
        }

        void generate(String user, String subtaskInclusion) {
            TestDeveloperWorkloadReportPermissions.this.navigation.gotoPage("secure/ConfigureReport.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin%3Adeveloper-workload&Next=Next&developer=" + user + "&subtaskInclusion=" + subtaskInclusion);
        }

        void generateWithoutSubtasks(String user) {
            this.generate(user, "onlyAssigned");
        }

        void generateWithUnassignedSubtasks(String user) {
            this.generate(user, "assignedAndUnassigned");
        }
    }

    class BobLoginTests {
        BobLoginTests() {
        }

        private void testFredUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Fred Normal");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "2", "3 days, 6 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "2", "3 days, 6 hours");
        }

        private void testFredUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Fred Normal");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "2", "3 days, 6 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "2", "3 days, 6 hours");
        }

        private void testBobUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Bob The Builder");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "9", "4 days, 5 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "9", "4 days, 5 hours");
        }

        private void testBobUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Bob The Builder");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "10", "1 week, 4 days, 1 hour");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "10", "1 week, 4 days, 1 hour");
        }
    }

    class FredLoginTests {
        FredLoginTests() {
        }

        private void testFredUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Fred Normal");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "8", "1 week, 4 days, 6 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "8", "1 week, 4 days, 6 hours");
        }

        private void testFredUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Fred Normal");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "8", "1 week, 4 days, 6 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "8", "1 week, 4 days, 6 hours");
        }

        private void testBobUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Bob The Builder");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "3", "3 days, 7 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "3", "3 days, 7 hours");
        }

        private void testBobUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Bob The Builder");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "4", "1 week, 3 days, 3 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "4", "1 week, 3 days, 3 hours");
        }
    }

    class AdminLoginTests {
        AdminLoginTests() {
        }

        private void testFredUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Fred Normal");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "8", "1 week, 4 days, 6 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "8", "1 week, 4 days, 6 hours");
        }

        private void testFredUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Fred Normal");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "8", "1 week, 4 days, 6 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "8", "1 week, 4 days, 6 hours");
        }

        private void testBobUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Bob The Builder");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "9", "4 days, 5 hours");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "9", "4 days, 5 hours");
        }

        private void testBobUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.tester.assertTextPresent("Bob The Builder");
            String response = TestDeveloperWorkloadReportPermissions.this.tester.getDialog().getResponseText();
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "homosapien", "10", "1 week, 4 days, 1 hour");
            TestDeveloperWorkloadReportPermissions.this.assertions.text().assertTextSequence(response, "Total", "10", "1 week, 4 days, 1 hour");
        }
    }
}

