/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS})
@LoginAs(user="admin")
public class TestPieChartReport
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestPieChartWithCustomField.xml");
    }

    @Test
    public void testPieChartXSS() throws Exception {
        this.administration.backdoor().usersAndGroups().addUser("testuser", "testuser", "\"><img src=x onerror=alert(1)>", "testuser@example.com");
        this.navigation.gotoPage("secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=assignees&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
    }

    @Test
    public void testPieChartReportWithGroupCustomField() {
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=customfield_10010&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Pie Chart Report");
        this.textAssertions.assertTextSequence(new TableLocator(this.tester, "singlefieldpie-report-datatable"), "None", "4", "100%");
    }

    @Test
    public void testPieChartReportWithMultiSelectCustomField() {
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=customfield_10011&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Pie Chart Report");
        this.textAssertions.assertTextSequence(new TableLocator(this.tester, "singlefieldpie-report-datatable"), "None", "4", "100%");
    }

    @Test
    public void testPieChartReportWithProjectCustomField() {
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=customfield_10012&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Pie Chart Report");
        this.textAssertions.assertTextSequence(new TableLocator(this.tester, "singlefieldpie-report-datatable"), "None", "4", "100%");
    }

    @Test
    public void testPieChartReportWithSelectCustomField() {
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=customfield_10013&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Pie Chart Report");
        this.textAssertions.assertTextSequence(new TableLocator(this.tester, "singlefieldpie-report-datatable"), "None", "4", "100%");
    }

    @Test
    public void testPieChartReportWithUserCustomField() {
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=customfield_10014&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Pie Chart Report");
        this.textAssertions.assertTextSequence(new TableLocator(this.tester, "singlefieldpie-report-datatable"), "None", "4", "100%");
    }

    @Test
    public void testPieChartReportWithVersionCustomField() {
        this.navigation.gotoPage("/secure/ConfigureReport.jspa?projectOrFilterId=project-10000&statistictype=customfield_10000&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Apie-report&Next=Next");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Pie Chart Report");
        this.textAssertions.assertTextSequence(new TableLocator(this.tester, "singlefieldpie-report-datatable"), "None", "4", "100%");
    }
}

