/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.USERS_AND_GROUPS, Category.FIELDS, Category.SCHEMES})
@LoginAs(user="admin")
@DevMode(enabled=false)
public class TestSingleLevelGroupByReport
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testRunReportLoggedIn() {
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.navigation.login("admin", "admin");
        this.runReport();
    }

    @Test
    public void testRunReportAnonymously() {
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.navigation.logout();
        this.runReport();
    }

    public void runReport() {
        this.navigation.runReport(10001L, "com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.textAssertions.assertTextPresent("Select a filter to display");
        this.textAssertions.assertTextPresent("Select a field to group by");
        this.tester.setFormElement("filterid", "10000");
        this.tester.submit("Next");
        this.textAssertions.assertTextPresent("Single Level Group By Report");
        this.textAssertions.assertTextPresent("MKY-2");
        this.textAssertions.assertTextPresent("MKY-1");
        this.textAssertions.assertTextPresent("0 of 2 issues have been resolved");
        Node headerLink = new CssLocator(this.tester, ".stat-heading h3 a").getNode();
        Assert.assertEquals((String)"header cell should display user name", (Object)"Administrator", (Object)headerLink.getNodeValue());
        String link = headerLink.getAttributes().getNamedItem("href").getNodeValue();
        Assert.assertTrue((String)"header cell should contain a link to a filtered results page", (boolean)link.contains("jql=project+%3D+10001+AND+issuetype+%3D+1+AND+assignee+%3D+admin+ORDER+BY+key+DESC"));
    }

    @Test
    public void testVersionIsEncoded() {
        this.administration.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.textAssertions.assertTextPresent("&quot;version&lt;input &gt;");
        this.textAssertions.assertTextNotPresent("\"version<input >");
        Node headerElement = new CssLocator(this.tester, ".stat-heading h3").getNodes()[0];
        Assert.assertTrue((String)"a span element with the release icon should be present", (new CssLocator(headerElement, "span.aui-icon").getNodes().length == 1 ? 1 : 0) != 0);
        Node headerLink = new CssLocator(headerElement, "a").getNode();
        Assert.assertEquals((String)"header cell should display correct version name", (Object)"New Version 1", (Object)headerLink.getNodeValue());
        String link = headerLink.getAttributes().getNamedItem("href").getNodeValue();
        Assert.assertTrue((String)"header cell should contain a link to a filtered results page", (boolean)link.contains("jql=project+%3D+HSP+AND+fixVersion+%3D+%22New+Version+1%22+ORDER+BY+key+DESC"));
    }

    @Test
    public void testFieldVisibility() {
        this.administration.restoreDataWithLicense("TestVersionAndComponentsWithHTMLNames.xml", LicenseKeys.COMMERCIAL.getLicenseString());
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, true);
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Resolution");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, false);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Priority");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, false);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Resolution");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "This is a test to see if field is shown");
        this.tester.submit();
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("add-field-configuration");
        this.tester.setFormElement("fieldLayoutName", "Many Hidden Fields");
        this.tester.submit("Add");
        this.tester.clickLink("hide_6");
        this.tester.clickLink("hide_10");
        this.tester.clickLink("hide_15");
        this.tester.clickLink("hide_17");
        this.tester.clickLink("issue_fields");
        this.tester.clickLink("add-field-configuration-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", "All Fields Hidden Scheme");
        this.tester.submit("Add");
        this.tester.clickLink("add-issue-type-field-configuration-association");
        this.tester.selectOption("issueTypeId", "Bug");
        this.tester.selectOption("fieldConfigurationId", "Many Hidden Fields");
        this.tester.submit("Add");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectFieldLayoutScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "All Fields Hidden Scheme");
        this.tester.submit("Associate");
        this.gotoSingleLevelGroupByReportAllFixForVersions();
        this.assertFieldsVisibleEnt();
    }

    @Test
    public void testFilterIdRequired() {
        this.administration.restoreBlankInstance();
        this.navigation.runReport(10001L, "com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.tester.submit("Next");
        this.textAssertions.assertTextPresent("Filter is a required field");
    }

    private void gotoSingleLevelGroupByReportAllFixForVersions() {
        this.navigation.runReport(10001L, "com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.tester.setFormElement("filterid", "10000");
        this.tester.selectOption("mapper", "Fix For Versions (all)");
        this.tester.submit("Next");
    }

    private void assertFieldsVisibleEnt() {
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            Assert.assertEquals((long)9L, (long)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 4);
                if (i == 8) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutioCell = table.getTableCell(i, 2);
                if (i == 8) {
                    Assert.assertTrue((boolean)resolutioCell.asText().contains("Unresolved"));
                    continue;
                }
                Assert.assertFalse((boolean)resolutioCell.asText().contains("Unresolved"));
            }
        }
        catch (SAXException e) {
            Assert.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void assertFieldsVisible(boolean priorityVisible, boolean resolutionVisible) {
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            Assert.assertEquals((long)7L, (long)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 4);
                if (priorityVisible) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutionCell = table.getTableCell(i, 2);
                if (resolutionVisible) {
                    Assert.assertTrue((boolean)resolutionCell.asText().contains("Unresolved"));
                    continue;
                }
                Assert.assertFalse((boolean)resolutionCell.asText().contains("Unresolved"));
            }
        }
        catch (SAXException e) {
            Assert.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void assertTableCellContainsPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        Assert.assertNotNull((Object)images);
        Assert.assertEquals((long)1L, (long)images.length);
        WebImage icon = images[0];
        Assert.assertTrue((boolean)icon.getSource().contains("/images/icons"));
    }

    private void assertTableCellContainsNoPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        Assert.assertTrue((images == null || images.length == 0 ? 1 : 0) != 0);
    }
}

