/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports.security.xss;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.SECURITY})
@LoginAs(user="admin")
public class TestXssInConfigureReport
extends BaseJiraFuncTest {
    private static final String XSS_ID = "__xss_script_injected_into_the_page__";
    private static final String XSS = "\"/><script id='__xss_script_injected_into_the_page__'></script>";
    private static final String XSS_ENCODED = "&quot;/&gt;&lt;script id=&#39;__xss_script_injected_into_the_page__&#39;&gt;&lt;/script&gt;";
    @Inject
    private Administration administration;

    @Test
    @Restore(value="TestConfigureReport.xml")
    public void testConfigureReportXSS() {
        this.assertXssNotInPage("/secure/ConfigureReport.jspa?atl_token=Pi7Pim9fcC&versionId=10000&sortingOrder=least&completedFilter=all&subtaskInclusion='all\"\"/><script id='__xss_script_injected_into_the_page__'></script>'&selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&Next=Next");
    }

    @Test
    @RestoreBlankInstance
    public void testConfigureReportXssFromCustomFieldName() {
        this.backdoor.customFields().createCustomField(XSS, "", CustomFields.builtInCustomFieldKey("userpicker"), CustomFields.builtInCustomFieldKey("userpickergroupsearcher"));
        this.assertXssNotInPage("/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin:pie-report");
    }

    private void assertXssNotInPage(String url) {
        this.tester.gotoPage(url);
        this.tester.assertElementNotPresent(XSS_ID);
        this.tester.assertTextNotPresent(XSS);
        List<String> optionLabels = this.readOptionLabels("statistictype_select");
        if (!optionLabels.isEmpty()) {
            Assert.assertTrue((String)("Option &quot;/&gt;&lt;script id=&#39;__xss_script_injected_into_the_page__&#39;&gt;&lt;/script&gt; not found in page from " + optionLabels), (boolean)optionLabels.stream().anyMatch(optionLabel -> optionLabel.contains(XSS_ENCODED)));
        } else {
            this.tester.assertTextPresent(XSS_ENCODED);
        }
    }

    private List<String> readOptionLabels(String selectId) {
        ArrayList<String> optionValues = new ArrayList<String>();
        HTMLSelectElement select = (HTMLSelectElement)this.tester.getDialog().getElement(selectId);
        if (select == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < select.getOptions().getLength(); ++i) {
            HTMLOptionElement option = (HTMLOptionElement)select.getOptions().item(i);
            optionValues.add(option.getText());
        }
        return optionValues;
    }
}

