/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.database;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import java.sql.Timestamp;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.DATABASE})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestChangeGroupDatetimePrecision
extends BaseJiraFuncTest {
    private final long projectId = 10000L;
    private String issueKey;

    @Before
    public void setupTest() {
        IssueCreateResponse createResponse = this.backdoor.issues().createIssue(10000L, "Issue 1");
        this.issueKey = createResponse.key();
    }

    @Test
    public void addingLabelsShouldHaveDifferentChangeGroupCreatedValue() throws InterruptedException {
        this.backdoor.issues().addLabel(this.issueKey, "LABEL1");
        Thread.sleep(30L);
        this.backdoor.issues().addLabel(this.issueKey, "LABEL2");
        List<Timestamp> historyMetadata = this.backdoor.issueNavControl().getHistoryTimestamp(this.issueKey);
        MatcherAssert.assertThat((Object)historyMetadata.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)historyMetadata.get(0), (Matcher)Is.is((Matcher)Matchers.not((Object)historyMetadata.get(1))));
    }
}

