/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.database;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.parser.SystemInfoParser;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.DATABASE})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestDatabaseCollationReader
extends BaseJiraFuncTest {
    @Inject
    private SystemInfoParser systemInfoParser;

    @Test
    public void testDatabaseCollationReadSuccessfully() {
        if (this.getDatabaseType().startsWith("hsql") || this.getDatabaseType().startsWith("h2")) {
            return;
        }
        String databaseCollation = this.systemInfoParser.getSystemInfo().getProperty("Database collation");
        MatcherAssert.assertThat((String)("Could not read collation for database type " + this.getDatabaseType()), (Object)databaseCollation, (Matcher)Matchers.not((Matcher)Matchers.isOneOf((Object[])new String[]{null, "", "null", "Unknown"})));
    }

    private String getDatabaseType() {
        return this.systemInfoParser.getSystemInfo().getDatabaseType();
    }
}

