/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.database;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.EntityEngineControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.DATABASE})
@RestoreBlankInstance
public class TestDatabaseLargeInQueries
extends BaseJiraFuncTest {
    @Test
    public void testLargeInQueryNumeric() {
        ArrayList<Long> values = new ArrayList<Long>();
        for (long value = 8000L; value < 50001L; ++value) {
            values.add(value);
        }
        List<Map<String, String>> results = this.backdoor.entityEngine().findByValueList("Project", "id", values, (List<String>)ImmutableList.of((Object)"id", (Object)"name"), EntityEngineControl.ValueType.NUMBER);
        Assert.assertThat(results, (Matcher)Matchers.containsInAnyOrder((Object[])new Map[]{ImmutableMap.of((Object)"id", (Object)10000, (Object)"name", (Object)"homosapien"), ImmutableMap.of((Object)"id", (Object)10001, (Object)"name", (Object)"monkey")}));
    }

    @Test
    public void testLargeInQueryString() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("homosapien");
        for (int i = 0; i < 42050; ++i) {
            values.add(String.valueOf(i));
        }
        List<Map<String, String>> results = this.backdoor.entityEngine().findByValueList("Project", "name", values, (List<String>)ImmutableList.of((Object)"id", (Object)"name"), EntityEngineControl.ValueType.STRING);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)10000, (Object)"name", (Object)"homosapien")), results);
    }

    @Test
    public void testLargeNumberOfParametersWithSmallerInFragments() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("homosapien");
        for (int i = 0; i < 1200; ++i) {
            values.add(String.valueOf(i));
        }
        List<Map<String, String>> results = this.backdoor.entityEngine().findByValueList2Fields("Project", "lead", "name", values, (List<String>)ImmutableList.of((Object)"id", (Object)"name"), EntityEngineControl.ValueType.STRING);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)10000, (Object)"name", (Object)"homosapien")), results);
    }
}

