/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ShareClient
extends RestApiClient {
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    public ShareClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.environmentData = environmentData;
    }

    ShareClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData, String version) {
        super((JIRAEnvironmentData)environmentData, version);
        this.environmentData = environmentData;
    }

    public ParsedResponse shareIssue(String issueKey, Set<String> usernames, @Nullable Set<String> emails, String message) {
        ShareBean bean = new ShareBean(usernames, emails, message, null);
        return this.postToShareResource("issue/" + issueKey, bean);
    }

    public ParsedResponse shareSavedSearch(String searchRequestId, Set<String> usernames, @Nullable Set<String> emails, String message) {
        ShareBean bean = new ShareBean(usernames, emails, message, null);
        return this.postToShareResource("filter/" + searchRequestId, bean);
    }

    public ParsedResponse shareSearchQuery(String jql, Set<String> usernames, @Nullable Set<String> emails, String message) {
        ShareBean bean = new ShareBean(usernames, emails, message, jql);
        return this.postToShareResource("search", bean);
    }

    private ParsedResponse postToShareResource(String path, ShareBean shareBean) {
        return this.toResponse(() -> {
            WebTarget shareResource = this.getShareResource().path(path);
            return (Response)shareResource.request().post(Entity.json((Object)shareBean), Response.class);
        });
    }

    private WebTarget getShareResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("share").path("1.0");
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    static class ShareBean {
        public Set<String> usernames;
        public Set<String> emails;
        public String message;
        public String jql;

        public ShareBean(Set<String> usernames, Set<String> emails, String message, String jql) {
            this.usernames = usernames;
            this.emails = emails;
            this.message = message;
            this.jql = jql;
        }
    }
}

