/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.EMAIL, Category.ISSUES})
@LoginAs(user="admin")
public class TestBulkDeleteIssuesNotifications
extends EmailBaseFuncTestCase {
    @Inject
    protected TextAssertions textAssertions;
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private LocatorFactory locator;

    @Test
    @Restore(value="TestBulkDeleteIssuesNotifications.xml")
    public void testBulkDeleteNoNoEmatifications() throws InterruptedException {
        this.configureAndStartSmtpServer();
        this.bulkDeleteAllIssues(false, false);
        this.flushMailQueueAndWait(0);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)0L, (long)mimeMessages.length);
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotifications.xml")
    public void testBulkDeleteNotifications() throws InterruptedException, MessagingException {
        this.configureAndStartSmtpServerWithNotify();
        this.bulkDeleteAllIssues(true, false);
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        this.assertRecipientsHaveMessages((Collection<String>)ImmutableList.of((Object)"admin@example.com", (Object)"fred@example.com"));
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotificationsWithSubtasks.xml")
    public void testBulkDeleteSubtaskNoNotifications() throws InterruptedException {
        this.configureAndStartSmtpServer();
        this.bulkDeleteAllIssues(false, true);
        this.flushMailQueueAndWait(0);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)0L, (long)mimeMessages.length);
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotificationsWithSubtasks.xml")
    public void testBulkDeleteSubtaskNotifications() throws InterruptedException, MessagingException {
        this.configureAndStartSmtpServerWithNotify();
        this.bulkDeleteAllIssues(true, true);
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)3L, (long)mimeMessages.length);
        this.assertRecipientsHaveMessages((Collection<String>)ImmutableList.of((Object)"admin@example.com", (Object)"fred@example.com"));
        ArrayList<String> subjects = new ArrayList<String>();
        List<MimeMessage> adminMessages = this.getMessagesForRecipient("admin@example.com");
        for (MimeMessage adminMessage : adminMessages) {
            subjects.add(adminMessage.getSubject());
        }
        Assert.assertThat(subjects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"[JIRATEST] (HSP-2) This is my bug", "[JIRATEST] (HSP-4) Subtask1"}));
        List<MimeMessage> fredMessages = this.getMessagesForRecipient("fred@example.com");
        this.assertEmailSubjectEquals(fredMessages.get(0), "[JIRATEST] (HSP-3) This is fred's bug");
    }

    private void bulkDeleteAllIssues(boolean sendMail, boolean subtaskPresent) {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.submit("Next");
        this.tester.setFormElement("operation", "bulk.delete.operation.name");
        this.tester.submit("Next");
        if (!sendMail) {
            this.tester.uncheckCheckbox("sendBulkNotification");
        }
        this.tester.submit("Next");
        if (!sendMail) {
            this.textAssertions.assertTextSequence(this.locator.page(), "Email notifications will", "NOT", "be sent for this update.");
        } else {
            this.tester.assertTextPresent("Email notifications will be sent for this update.");
        }
        if (subtaskPresent) {
            this.tester.assertTextPresent("Subtask1");
        } else {
            this.tester.assertTextNotPresent("Subtask1");
        }
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.assertElementNotPresent("issuetable");
    }
}

