/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.JiraMode;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
public class TestContactAdministrators
extends EmailBaseFuncTestCase {
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testSubjectIsNotEvaluated() throws Exception {
        this.configureAndStartSmtpServer();
        this.backdoor.generalConfiguration().setJiraMode(JiraMode.PRIVATE).setContactAdminFormOn();
        String subject = "><& #set($v=\"s\"); $v.getClass().forName(\"java.net.InetAddress\").getMethod(\"getLocalHost\").invoke(null)";
        this.tester.gotoPage("/secure/ContactAdministrators!default.jspa");
        this.tester.setFormElement("from", "TEST@TEST.NET");
        this.tester.setFormElement("subject", subject);
        this.tester.setFormElement("details", "something");
        this.tester.submit("Send");
        this.flushMailQueueAndWait(1);
        String messageSubject = this.mailService.getReceivedMessage().getSubject();
        this.textAssertions.assertTextPresent(messageSubject, subject);
    }
}

